<?php
/**
 * Single Product Up-Sells
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/up-sells.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}

$data = ocolus_generate_carousel_products('woo_upsell');

if ($upsells && !empty($data)) : ?>

    <section class="up-sells upsells products">

        <h2><?php
            if ($data['title'] == '') {
                esc_html_e('You may also like&hellip;', 'ocolus');
            } else {
                echo esc_html($data['title']);
            }
            ?>
        </h2>

        <div class="owl-slick" <?php echo esc_attr($data['carousel']); ?>>

            <?php foreach ($upsells as $upsell) : ?>

                <?php
                $post_object = get_post($upsell->get_id());
                $classes     = array('product-item', $data['style']);

                setup_postdata($GLOBALS['post'] =& $post_object);
                ?>
                <div <?php wc_product_class($classes, $upsell); ?>>
                    <?php wc_get_template_part('product-style/content-product', $data['style']); ?>
                </div>

            <?php endforeach; ?>

        </div>

    </section>

<?php endif;
wp_reset_postdata();
