<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.1
 */
defined( 'ABSPATH' ) || exit;
// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( !function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}
global $product;
$single_thumbnail  = ocolus_get_option( 'single_product_thumbnail', 'horizontal' );
$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters( 'woocommerce_single_product_image_gallery_classes', array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $product->get_image_id() ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);
$attachment_ids    = $product->get_gallery_image_ids();
if ( $attachment_ids && has_post_thumbnail() ) {
	$wrapper_classes[] = 'has-gallery';
}
$wrapper_classes[] = 'sticky-static-content';
/* DATA CAROUSEL */
$prefix     = 'product_thumbnail';
$data_slide = array(
	'infinite'     => false,
	'slidesMargin' => 10,
	'slidesToShow' => 4,
);
if ( $single_thumbnail == 'vertical_left' || $single_thumbnail == 'vertical_right' ) {
	$data_slide = array_merge( $data_slide,
		array(
			'vertical'        => true,
			'verticalSwiping' => true,
		)
	);
}
$data_slide['responsive'] = array(
	array(
		'breakpoint' => 1500,
		'settings'   => array(
			'slidesToShow' => 4,
		),
	),
	array(
		'breakpoint' => 480,
		'settings'   => array(
			'vertical'        => false,
			'verticalSwiping' => false,
			'slidesToShow'    => 3,
		),
	),
);
?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>"
     data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;"
     data-attr_slick="<?php echo esc_attr( json_encode( apply_filters( 'ocolus_product_slide_thumbnail', $data_slide ) ) ); ?>">

	<?php do_action( 'ocolus_before_product_gallery_wrapper' ); ?>

    <figure class="woocommerce-product-gallery__wrapper">
		<?php
		if ( $product->get_image_id() ) {
			$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
		} else {
			$html = '<div class="woocommerce-product-gallery__image--placeholder">';
			$html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'ocolus' ) );
			$html .= '</div>';
		}
		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped
		do_action( 'woocommerce_product_thumbnails' );
		?>
    </figure>

	<?php do_action( 'ocolus_after_product_gallery_wrapper' ); ?>

</div>
