<?php
/**
 *
 * Name: Product Style 17
 * Shortcode: true
 * Theme Option: true
 **/
?>
<?php
global $product;
$functions = array(
	array( 'remove_action', 'woocommerce_after_shop_loop_item_title', 'woocommerce_template_loop_rating', 5 ),
);
ocolus_add_action( $functions );
?>
    <div class="product-inner">
        <div class="product-info equal-elem">
			<?php
			/**
			 * Hook: woocommerce_shop_loop_item_title.
			 *
			 * @hooked woocommerce_template_loop_product_title - 10
			 */
			do_action( 'woocommerce_shop_loop_item_title' );
			ocolus_post_taxonomy( $product->get_id(), 'product_cat' );
			?>
        </div>
        <div class="product-thumb">
			<?php
			/**
			 * Hook: woocommerce_before_shop_loop_item_title.
			 *
			 * @hooked woocommerce_show_product_loop_sale_flash - 10
			 * @hooked woocommerce_template_loop_product_thumbnail - 10
			 */
			do_action( 'woocommerce_before_shop_loop_item_title' );
			?>
        </div>
		<div class="product-info">
            <?php
            /**
             * Hook: woocommerce_after_shop_loop_item_title.
             *
             * @hooked woocommerce_template_loop_rating - 5
             * @hooked woocommerce_template_loop_price - 10
             */
            do_action( 'woocommerce_after_shop_loop_item_title' );
            ?>
            <?php if ( $product->is_type( 'simple' ) ) : ?>
                <div class="add-to-cart">
                    <?php ocolus_simple_add_to_cart_button(); ?>
                </div>
            <?php else : ?>
                <?php
                /**
                 * woocommerce_after_shop_loop_item hook.
                 *
                 * @hooked woocommerce_template_loop_product_link_close - 5
                 * @hooked woocommerce_template_loop_add_to_cart - 10
                 */
                do_action( 'woocommerce_after_shop_loop_item' );
                ?>
            <?php endif; ?>
        </div>
    </div>
<?php
ocolus_add_action( $functions, true );
