<?php
/**
 * Content wrappers
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/wrapper-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @author        WooThemes
 * @package    WooCommerce/Templates
 * @version     3.3.0
 */
if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$page_layout     = ocolus_page_layout();
$class_contain   = array( 'site-content' );
$thumbnail       = ocolus_get_option( 'single_product_thumbnail', 'horizontal' );
$description     = ocolus_get_option( 'product_description_style', 'desc_01' );
$class_contain[] = "container";
$class_contain[] = "sidebar-{$page_layout['layout']}";
if ( is_product() ) {
	$class_contain[] = 'product-page';
	$class_contain[] = $thumbnail;
	$class_contain[] = $description;
	if ( $thumbnail == 'sticky_info' ) {
		wp_enqueue_script( 'ocolus-sticky' );
	}
} else {
	$class_contain[] = 'shop-page';
}
add_filter( 'ocolus_filter_product_item', 'ocolus_woocommerce_grid_products', 10 ); ?>
<!-- .site-content-contain -->
<div id="content" class="<?php echo esc_attr( implode( ' ', $class_contain ) ); ?>">
    <div id="primary" class="content-area">
        <main id="main" class="site-main" role="main">
