<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;

global $product;

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
	return;
}
$style          = 'style-01';
$short_title    = ocolus_get_option( 'woo_short_title' );
$attachment_ids = $product->get_gallery_image_ids();
$classes        = array( 'product-item' );
if ( $short_title == 1 ) {
	$classes[] = 'short-title';
}
if ( ! empty( $attachment_ids ) && ! ocolus_is_mobile( true ) ) {
	$classes[] = 'has-gallery';
}
if ( $product->is_type( 'variable' ) && $product->has_child() ) {
	$classes[] = 'has-children';
}
if ( has_filter( 'ocolus_filter_product_item' ) ) {
	$product_item = apply_filters( 'ocolus_filter_product_item', array() );
	if ( isset( $product_item['class'] ) ) {
		if ( is_array( $product_item['class'] ) ) {
			$classes = array_merge( $classes, $product_item['class'] );
		} else {
			$classes[] = $product_item['class'];
		}
	}
	if ( isset( $product_item['style'] ) ) {
		$style = $product_item['style'];
	}
	if ( isset( $product_item['list_style'] ) && $product_item['list_style'] == 'isotope' ) {
		$meta_product = get_post_meta( $product->get_id(), '_custom_product_side_options', true );
		if ( isset( $meta_product['image_isotope'] ) ) {
			if ( isset( $product_item['current_size'] ) && $product_item['current_size'] == 'enable' ) {
				$meta_product['image_isotope'] = '1x1';
			}
			$classes[] = "isotope-size-{$meta_product['image_isotope']}";
		}
	}
}
$classes[] = $style;
?>
<li <?php wc_product_class( $classes, $product ); ?>>
	<?php wc_get_template_part( 'product-style/content-product', $style ); ?>
</li>
