<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Video"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Video' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Video extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_video';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_video', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-video' );
			$css_class[] = $atts['style'];
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_video', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* START */
			$video_inline = true;
			if ( $atts['link_video'] && ( $atts['style'] == 'style-02' || $atts['style'] == 'style-03' ) ) {
				$video_inline = false;
			}
			$button_video = esc_html__( 'Play', 'ocolus' );
			if ( $atts['button_video'] != '' ) $button_video = $atts['button_video'];
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php
				if ( $video_inline ) {
					$instance = array(
						'src'     => $atts['link_video'],
						'poster'  => wp_get_attachment_image_url( $atts['video_bg'], 'full' ),
						'width'   => 905,
						'height'  => 535,
						'preload' => 'auto',
					);
					if ( $atts['autoplay'] == 'on' ) {
						$instance['autoplay'] = 'on';
					}
					if ( $atts['loop'] == 'on' ) {
						$instance['loop'] = 'on';
					}
					echo wp_video_shortcode($instance);
				}
				?>
                <?php if ( $atts['style'] == 'style-03' && $atts['video_bg'] ) : ?>
                    <figure class="thumb-video">
                        <?php echo wp_get_attachment_image( $atts['video_bg'], 'full' ); ?>
                    </figure>
                <?php endif; ?>
				<div class="content-video">
                    <?php if ( $atts['title'] ): ?>
                        <h4 class="title-video"><?php echo wp_specialchars_decode( $atts['title'] ); ?></h4>
                    <?php endif; ?>
                    <?php if ( $atts['desc'] ): ?>
                        <p class="desc"><?php echo wp_specialchars_decode( $atts['desc'] ); ?></p>
                    <?php endif; ?>
                    <?php if ( !$video_inline ):
                        wp_enqueue_style( 'magnific-popup' );
                        wp_enqueue_script( 'ocolus-magnific-popup' );
                        ?>
                        <div>
                            <a class="ovic-magnific-popup video" href="<?php echo esc_url( $atts['link_video'] ); ?>">
                                <?php echo esc_html( $button_video ); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
			<?php
			return apply_filters( 'Shortcode_Ovic_Video', ob_get_clean(), $atts, $content );
		}
	}

	new Shortcode_Ovic_Video();
}