<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Vendor_List"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Vendor_List' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Vendor_List extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_vendor_list';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_vendor_list', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-vendor-list', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_vendor_list', $atts );
			/* START */
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php
				add_filter( 'wcmp_vendor_list_data',
					function ( $data ) use ( $atts ) {
						$data['style'] = $atts['style'];

						return $data;
					}
				);
				echo ocolus_do_shortcode( 'wcmp_vendorslist',
					array(
						'orderby' => 'registered',
						'order'   => 'ASC',
					)
				);
				?>
            </div>
			<?php
			return apply_filters( 'Shortcode_Ovic_Vendor_List', ob_get_clean(), $atts, $content );
		}
	}

	new Shortcode_Ovic_Vendor_List();
}