<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Tabs"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Tabs' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Tabs extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_tabs';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_tabs', $atts ) : $atts;
			extract( $atts );
			$css_class            = array( 'ovic-tabs' );
			$css_class[]          = isset( $atts['style'] ) ? $atts['style'] : '';
			$css_class[]          = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_tabs', $atts );
			$sections             = $this->get_all_attributes( 'vc_tta_section', $content );
			$rand                 = uniqid();
			$param_vc_tta_section = array();
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php if ( $sections && is_array( $sections ) && count( $sections ) > 0 ): ?>
                    <div class="tabs-head">
						<?php if ( $atts['tab_title'] ): ?>
                            <h3 class="tabs-title"><?php echo esc_html( $atts['tab_title'] ); ?></h3>
						<?php endif; ?>
                        <ul class="tabs ocolus-tabs" role="tablist">
							<?php foreach ( $sections as $key => $section ) : ?>
								<?php
								/* Get icon from section tabs */
								$class_items       = array( 'tab-item' );
								$class_link        = array( 'tab-link' );
								$add_icon          = isset( $section['add_icon'] ) ? $section['add_icon'] : '';
								$position_icon     = isset( $section['i_position'] ) ? $section['i_position'] : '';
								$section['i_type'] = isset( $section['i_type'] ) ? $section['i_type'] : 'fontawesome';
								if ( $section['i_type'] == 'image' && !empty( $section['image_icon'] ) ) {
									$icon_html = wp_get_attachment_image( $section['image_icon'], 'full' );
								} else {
									$icon_html = $this->constructIcon( $section );
								}
								$section_id = $section['tab_id'] . '-' . $rand;
								if ( $key == $atts['active_section'] ) {
									$class_items[] = 'active';
									$class_link[]  = 'loaded';
								}
								$param_vc_tta_section[$section['tab_id']] = $section['content'];
								?>
                                <li class="<?php echo esc_attr( implode( ' ', $class_items ) ); ?>">
                                    <a class="<?php echo esc_attr( implode( ' ', $class_link ) ); ?>"
                                       data-ajax="<?php echo esc_attr( $atts['ajax_check'] ) ?>"
                                       data-animate="<?php echo esc_attr( $atts['css_animation'] ); ?>"
                                       data-section="<?php echo esc_attr( md5( $section['tab_id'] ) ); ?>"
                                       href="#<?php echo esc_attr( $section_id ); ?>">
										<?php echo ( 'true' === $add_icon && 'right' !== $position_icon ) ? $icon_html : ''; ?>
                                        <span><?php echo esc_html( $section['title'] ); ?></span>
										<?php echo ( 'true' === $add_icon && 'right' === $position_icon ) ? $icon_html : ''; ?>
                                    </a>
                                </li>
							<?php endforeach; ?>
                        </ul>
                    </div>
					<?php $count = 0; ?>
                    <div class="tabs-container">
						<?php foreach ( $param_vc_tta_section as $tab_id => $section ): ?>
							<?php
							$active_tab = array( 'tab-panel' );
							$section_id = $tab_id . '-' . $rand;
							if ( $count == $atts['active_section'] ) {
								$active_tab[] = 'active';
							}
							?>
                            <div class="<?php echo esc_attr( implode( ' ', $active_tab ) ); ?>"
                                 id="<?php echo esc_attr( $section_id ); ?>">
								<?php if ( $atts['ajax_check'] == '1' ) :
									wp_localize_script( "ocolus-main", "ovic_vc_tta_section_" . md5( $tab_id ), array( 'content' => urlencode( $section ) ) );
									if ( $count == $atts['active_section'] ) :
										echo wpb_js_remove_wpautop( $section );
									endif;
								else :
									echo wpb_js_remove_wpautop( $section );
								endif;
								$count++; ?>
                            </div>
						<?php endforeach; ?>
                    </div>
				<?php endif; ?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Tabs', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Tabs();
}