<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Socials"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Socials' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Socials extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_socials';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_socials', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-socials', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_socials', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* START */
			$all_socials     = ocolus_get_option( 'user_all_social' );
			$get_all_socials = is_array( $atts['socials'] ) ? $atts['socials'] : explode( ',', $atts['socials'] );
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
                <div class="content-socials">
					<?php if ( !empty( $get_all_socials ) ) : ?>
                        <ul class="socials-list">
							<?php foreach ( $get_all_socials as $value ) : ?>
								<?php if ( isset( $all_socials[$value] ) ) :
									$array_socials = $all_socials[$value]; ?>
                                    <li>
                                        <a href="<?php echo esc_url( $array_socials['link_social'] ) ?>">
                                            <span class="icon <?php echo esc_attr( $array_socials['icon_social'] ); ?>"></span>
											<span class="text"><?php echo esc_html( $array_socials['title_social'] ); ?></span>
                                        </a>
                                    </li>
								<?php endif; ?>
							<?php endforeach; ?>
                        </ul>
					<?php endif; ?>
                </div>
            </div>
			<?php
			return apply_filters( 'Shortcode_Ovic_Socials', ob_get_clean(), $atts, $content );
		}
	}

	new Shortcode_Ovic_Socials();
}