<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var "Shortcode_Ovic_Slide"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Slide' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Slide extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_slide';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_slide', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-slide' );
			$css_class[] = $atts['layout'];
			$css_class[] = $atts['owl_rows_space'];
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_slide', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* START */
			$html         = '';
			$class_slide  = array( 'owl-slick equal-container better-height' );
			$owl_settings = Ovic_VC_Params::generate_slide_attr( $atts['carousel'] );
			if ( $atts['owl_navigation_style'] )
				$css_class[] = $atts['owl_navigation_style'];
			if ( $atts['owl_dot_style'] )
				$css_class[] = $atts['owl_dot_style'];
			/* CONTENT SLIDE */
			$html .= '<div class="' . esc_attr( implode( ' ', $css_class ) ) . '">';
			$html .= '<div class="' . esc_attr( implode( ' ', $class_slide ) ) . '" ' . esc_attr( $owl_settings ) . '>';
			$html .= wpb_js_remove_wpautop( $content );
			$html .= '</div>';
			$html .= '</div>';

			return apply_filters( 'Shortcode_Ovic_Slide', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Slide();
}