<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Ocolus_Products"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Products' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Products extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $enqueue;
		public $shortcode = 'ovic_products';

		public function action_before_shortcode( $atts )
		{
			/* Product Size */
			$width  = 300;
			$height = 300;
			if ( $atts['product_image_size'] ) {
				if ( $atts['product_image_size'] == 'custom' ) {
					$thumb_width  = $atts['product_custom_thumb_width'];
					$thumb_height = $atts['product_custom_thumb_height'];
				} else {
					list( $size_width, $size_height ) = explode( "x", $atts['product_image_size'] );
					$thumb_width  = $size_width;
					$thumb_height = $size_height;
				}
				if ( $thumb_width > 0 ) {
					$width = $thumb_width;
				}
				if ( $thumb_height > 0 ) {
					$height = $thumb_height;
				}
			}
			$product_item_class = array();
			$product_list_class = array(
				'products',
				$atts['target'],
				'equal-container',
				'better-height',
			);
			$owl_settings       = '';
			if ( $atts['productsliststyle'] == 'grid' ) {
				$product_list_class[] = 'product-list-grid row';
				$product_item_class[] = Ovic_VC_Params::generate_grid_attr( $atts['bootstrap'] );
			} elseif ( $atts['productsliststyle'] == 'owl' ) {
				$product_list_class[] = 'product-list-owl owl-slick';
				$product_item_class[] = $atts['owl_rows_space'];
				$owl_settings         = Ovic_VC_Params::generate_slide_attr( $atts['carousel'] );
			} elseif ( $atts['productsliststyle'] == 'isotope' ) {
				wp_enqueue_script( 'ocolus-grid-isotope' );
				$product_list_class[] = $atts['isotope_rows_space'];
				$product_list_class[] = 'ocolus-isotope';
				$product_item_class[] = 'isotope-item';
			}
			$product_list_class = implode( ' ', $product_list_class );
			$class_product      = array(
				'class'      => $product_item_class,
				'style'      => $atts['product_style'],
				'list_style' => $atts['productsliststyle'],
				'rows_space' => $atts['isotope_rows_space'],
			);
			if ( $atts['productsliststyle'] == 'isotope' ) {
				$class_product['current_size'] = $atts['current_size'];
			}
			/**
			 * CREATE FUNCTIONS
			 */
			$functions_width        = function () use ( $width ) { return $width; };
			$functions_height       = function () use ( $height ) { return $height; };
			$functions_product_item = function () use ( $class_product ) { return $class_product; };
			$functions_loop_start   = function () use ( $product_list_class, $owl_settings, $atts ) {
				$attr = array(
					'class' => $product_list_class,
				);
				if ( $atts['productsliststyle'] == 'isotope' ) {
					if ( $atts['col'] != '0' ) {
						$attr['data-cols'] = $atts['col'];
					}
					$attr['data-layout'] = $atts['layout_mode'];
				}
				if ( $atts['pagination'] == 'load_more' || $atts['pagination'] == 'infinite' ) {
					$attr['data-next_page']  = '2';
					$attr['data-total_page'] = wc_get_loop_prop( 'total_pages' );
				}
				$attr    = apply_filters( 'ocolus_wrapper_shortcode_product_attributes', $attr, $atts );
				$attr    = array_map( 'esc_attr', $attr );
				$wrapper = rtrim( "<ul" );
				foreach ( $attr as $name => $value ) {
					$wrapper .= " $name=" . '"' . $value . '"';
				}
				if ( $atts['productsliststyle'] == 'owl' ) {
					$wrapper .= " $owl_settings";
				}
				$wrapper .= '>';

				return $wrapper;
			};
			$functions_loop_end     = function () use ( $atts, $class_product, $width, $height ) {
				$loop_end = '</ul>';
				if ( $atts['pagination'] == 'load_more' || $atts['pagination'] == 'infinite' ) {
					wp_enqueue_script( "shortcode_enqueue_ovic_products" );
					$param_id   = "ocolus_shortcode_product_{$atts['ovic_vc_custom_id']}";
					$param_data = json_encode(
						array(
							'args'       => ocolus_shortcode_products_query( $atts ),
							'pagination' => $atts['pagination'],
							'list_style' => $atts['productsliststyle'],
							'target'     => $atts['target'],
							'class'      => $class_product,
							'size_thumb' => array( $width, $height ),
						)
					);
					$loop_end   .= "<script type='text/javascript'>\n";
					$loop_end   .= "/* <![CDATA[ */\n";
					$loop_end   .= "var $param_id = $param_data\n";
					$loop_end   .= "/* ]]> */\n";
					$loop_end   .= "</script>\n";
					/* BUTTON */
					if ( $atts['pagination'] == 'load_more' ) {
						$loop_end .= '<div class="button-products">';
						$loop_end .= '<a href="#" class="button ' . esc_attr( $atts['pagination'] ) . '-products">' . esc_html__( 'LOAD MORE', 'ocolus' ) . '</a>';
						$loop_end .= '</div>';
					}
				}
				if ( $atts['pagination'] == 'view_all' && $atts['view_all_button'] ) {
					$button           = vc_build_link( $atts['view_all_button'] );
					$button['title']  = $button['title'] != '' ? $button['title'] : esc_html__( 'ALL PRODUCTS', 'ocolus' );
					$button['url']    = $button['url'] != '' ? $button['url'] : '';
					$button['target'] = $button['target'] != '' ? $button['target'] : '_self';
					$loop_end         .= '<div class="button-products">';
					$loop_end         .= '<a href="' . esc_url( $button['url'] ) . '" target="' . esc_attr( $button['target'] ) . '" class="button all-products">' . esc_html( $button['title'] ) . '</a>';
					$loop_end         .= '</div>';
				}

				return $loop_end;
			};
			/**
			 * ACTIONS FUNCTIONS
			 */
			add_filter( 'ocolus_filter_product_item', $functions_product_item, 30 );
			add_filter( 'woocommerce_product_loop_start', $functions_loop_start, 30 );
			add_filter( 'woocommerce_product_loop_end', $functions_loop_end, 30 );
			add_filter( 'ocolus_shop_product_thumb_width', $functions_width, 30 );
			add_filter( 'ocolus_shop_product_thumb_height', $functions_height, 30 );
			remove_action( 'woocommerce_before_shop_loop', 'ocolus_control_before_shop_loop', 30 );
			remove_action( 'woocommerce_after_shop_loop', 'ocolus_control_after_shop_loop', 10 );
			remove_action( 'woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10 );
			/**
			 * ACTION BEFORE SHORTCODE
			 */
			do_action( 'ovic_before_shortcode_products', $atts );
		}

		public function action_after_shortcode( $atts )
		{
			remove_all_filters( 'ocolus_filter_product_item', 30 );
			remove_all_filters( 'woocommerce_product_loop_start', 30 );
			remove_all_filters( 'woocommerce_product_loop_end', 30 );
			remove_all_filters( 'ocolus_shop_product_thumb_width', 30 );
			remove_all_filters( 'ocolus_shop_product_thumb_height', 30 );
			remove_all_filters( 'woocommerce_shortcode_products_query' );
			add_action( 'woocommerce_before_shop_loop', 'ocolus_control_before_shop_loop', 30 );
			add_action( 'woocommerce_after_shop_loop', 'ocolus_control_after_shop_loop', 10 );
			add_action( 'woocommerce_before_shop_loop', 'woocommerce_output_all_notices', 10 );
			/**
			 * ACTION AFTER SHORTCODE
			 */
			do_action( 'ovic_after_shortcode_products', $atts );
		}

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_products', $atts ) : $atts;
			extract( $atts );
			$css_class = array( "ovic-products", $atts['product_style'], "{$atts['pagination']}-products" );
			if ( $atts['owl_dot_style'] ) {
				$css_class[] = $atts['owl_dot_style'];
			}
			if ( $atts['owl_navigation_style'] ) {
				$css_class[] = $atts['owl_navigation_style'];
			}
			$html          = '';
			$atts['class'] = $atts['productsliststyle'];
			$css_class[]   = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_products', $atts );
			/**
			 * RECENT VIEWS PRODUCTS
			 */
			if ( $atts['target'] == 'recent_viewed' ) {
				$atts['target'] = 'products';
				// Get recently viewed product cookies data
				$viewed_products = !empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array)explode( '|', wp_unslash( $_COOKIE['woocommerce_recently_viewed'] ) ) : array(); // @codingStandardsIgnoreLine
				$viewed_products = array_reverse( array_filter( array_map( 'absint', $viewed_products ) ) );
				if ( !empty( $viewed_products ) ) {
					$atts['ids'] = implode( ',', $viewed_products );
				} else {
					$atts['target'] = '';
				}
			}
			/**
			 * ACTION BEFORE SHORTCODE
			 */
			$this->action_before_shortcode( $atts );
			/**
			 * CONTENT PRODUCTS
			 */
			$html .= '<div data-id="' . esc_attr( $atts['ovic_vc_custom_id'] ) . '" class="' . esc_attr( implode( ' ', $css_class ) ) . '">';
			if ( $atts['title'] ) {
				$html .= '<div class="products-head">';
				$html .= '<h3 class="products-title">' . esc_html( $atts['title'] ) . '</h3>';
				$html .= '</div>';
			}
			if ( $atts['target'] != '' ) {
				$html .= ocolus_do_shortcode( $atts['target'], ocolus_shortcode_products_query( $atts ) );
			} else {
				$html .= '<span>' . esc_html__( 'No Product', 'ocolus' ) . '</span>';
			}
			$html .= '</div>';
			/**
			 * ACTION AFTER SHORTCODE
			 */
			$this->action_after_shortcode( $atts );

			return apply_filters( 'Shortcode_Ovic_Products', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Products();
}