(function ($) {
    'use strict';

    $.fn.ocolus_load_products = function (data_atts, _shortcode_id) {
        var $this             = $(this),
            $tab_animated     = 'fadeInUp',
            $data             = data_atts,
            $contain          = $('.ovic-products.' + _shortcode_id),
            $response_wrapper = $contain.find('ul.products'),
            $next_page        = $response_wrapper.data('next_page'),
            $total_page       = $response_wrapper.data('total_page'),
            $button           = $contain.find('.button-products a.button');

        $data.args.page     = $next_page;
        $data.args.paginate = false;

        $.ajax({
            type: 'POST',
            url: ocolus_main_params.ocolus_ajax_url.toString().replace('%%endpoint%%', 'product_load_more'),
            data: {
                security: ocolus_main_params.security,
                data: $data,
            },
            beforeSend: function () {
                if ( $data.pagination === 'load_more' ) {
                    $button.addClass('loading');
                } else {
                    $contain.addClass('loading');
                }
            },
            success: function (response) {
                if ( !response ) {
                    window[ 'is_busy_' + _shortcode_id ] = true;
                    return;
                }

                var product_items = $(response).find('.product-item');

                if ( $this.closest('.ovic-tabs').length ) {
                    $tab_animated = $this.closest('.ovic-tabs').find('.tabs-head a.loaded').data('animate');
                }
                if ( product_items.length ) {
                    if ( $tab_animated !== '' && $data.list_style === 'grid' ) {
                        product_items.each(function (i) {
                            var _this  = $(this),
                                _style = _this.attr('style'),
                                _delay = i * 100;

                            _style = (_style === undefined) ? '' : _style;
                            _this.attr('style', _style +
                                ';-webkit-animation-delay:' + _delay + 'ms;' +
                                '-moz-animation-delay:' + _delay + 'ms;' +
                                '-o-animation-delay:' + _delay + 'ms;' +
                                'animation-delay:' + _delay + 'ms;'
                            ).addClass($tab_animated + ' animated').one('webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function () {
                                _this.removeClass($tab_animated + ' animated');
                                _this.attr('style', _style);
                            });
                            $response_wrapper.append(_this);
                        });
                    } else {
                        if ( $data.list_style === 'owl' ) {
                            var _slick_config = $response_wrapper.data('slick'),
                                _lastSlide    = $response_wrapper.find('.last-slick').data('slick-index');

                            _slick_config.infinite = false;

                            product_items = $(response).find('.products').slick(_slick_config).find('.slick-slide');

                            $response_wrapper.slick('slickAdd', product_items);
                            $response_wrapper.slick('slickGoTo', _lastSlide);
                        } else {
                            $response_wrapper.append(product_items);
                            if ( $response_wrapper.hasClass('ocolus-isotope') && $.fn.ocolus_isotope_grid ) {
                                $response_wrapper
                                    .isotope('appended', product_items, true)
                                    .isotope('reloadItems')
                                    .ocolus_isotope_grid();
                            }
                        }
                    }
                    setTimeout(function ($response_wrapper) {
                        if ( $response_wrapper.hasClass('equal-container').length ) {
                            $response_wrapper.ocolus_better_equal_elems();
                        }
                        if ( $response_wrapper.find('.ocolus-countdown').length ) {
                            $response_wrapper.find('.ocolus-countdown').ocolus_countdown();
                        }
                        if ( $response_wrapper.find('.variations_form').length && $.fn.wc_variation_form ) {
                            $response_wrapper.find('.variations_form').each(function () {
                                $(this).wc_variation_form();
                            });
                        }
                    }, 10, $response_wrapper);
                    /* SET WINDOW VALUE */
                    if ( $next_page + 1 >= $total_page ) {
                        if ( $data.pagination === 'load_more' ) {
                            $button.parent().remove();
                        }
                        window[ 'is_busy_' + _shortcode_id ] = true;
                    } else {
                        window[ 'is_busy_' + _shortcode_id ] = false;
                        $response_wrapper.data('next_page', $next_page + 1);
                    }
                } else {
                    if ( $data.pagination === 'load_more' ) {
                        $button.parent().remove();
                    }
                    window[ 'is_busy_' + _shortcode_id ] = true;
                }
                if ( $data.pagination === 'load_more' ) {
                    $button.removeClass('loading');
                } else {
                    $contain.removeClass('loading');
                }
            },
        });
    };

    $.fn.ocolus_load_infinite = function () {
        $(this).each(function () {
            var _this           = $(this),
                _previousScroll = 0,
                _shortcode_id   = _this.attr('data-id'),
                _data_atts      = window[ 'ocolus_shortcode_product_' + _shortcode_id ];

            if ( _data_atts !== undefined && _data_atts.pagination === 'infinite' ) {

                window[ 'is_busy_' + _shortcode_id ] = false;

                if ( _data_atts.list_style !== 'owl' ) {

                    $(document).on('scroll', function () {

                        var _currentScroll = $(this).scrollTop(),
                            _offset        = _this.height() + _this.offset().top;

                        if ( _currentScroll > _previousScroll ) {

                            if ( $(window).scrollTop() + $(window).height() >= _offset ) {

                                if ( window[ 'is_busy_' + _shortcode_id ] === false ) {
                                    _this.ocolus_load_products(_data_atts, _shortcode_id);
                                }
                                window[ 'is_busy_' + _shortcode_id ] = true;
                            }
                        }

                        _previousScroll = _currentScroll;

                    });

                } else {

                    _this.find('.owl-slick').on('afterChange', function (event, slick) {
                        var lastSlide = $(event.target).find('.last-slick').data('slick-index');
                        if ( lastSlide === slick.slideCount - 1 && window[ 'is_busy_' + _shortcode_id ] === false ) {
                            _this.ocolus_load_products(_data_atts, _shortcode_id);
                        }
                    });

                }
            }
        });
    };

    $(document).on('click', '.ovic-products .load_more-products', function (e) {
        e.preventDefault();
        var _this         = $(this),
            _shortcode_id = _this.closest('.ovic-products').attr('data-id'),
            _data_atts    = window[ 'ocolus_shortcode_product_' + _shortcode_id ];

        _this.ocolus_load_products(_data_atts, _shortcode_id);
    });
    document.addEventListener("DOMContentLoaded", function () {
        if ( $('.ovic-products').length ) {
            $('.ovic-products').ocolus_load_infinite();
        }
    });
})(window.jQuery);