<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Pricing_Box"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Pricing_Box' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Pricing_Box extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_pricing_box';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_pricing_box', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-pricing-box' );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_pricing_box', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			ob_start();
			$link_button           = vc_build_link( $atts['button'] );
			$link_button['url']    = ( $link_button['url'] ) ? $link_button['url'] : '';
			$link_button['target'] = ( $link_button['target'] ) ? $link_button['target'] : '_self';
			$list_text             = vc_value_from_safe( $atts['list_text'] );
			$list_text             = explode( ',', $list_text );
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
                <div class="pricing-inner">
                    <div class="head-price">
						<div class="icon"><?php echo ocolus_get_icon_html( $atts ); ?></div>
						<?php if ( $atts['title'] ): ?>
                            <h4 class="title">
								<?php echo esc_html( $atts['title'] ); ?>
                            </h4>
						<?php endif; ?>
                        <div class="group-price">
							<?php if ( $atts['cur'] ): ?>
                                <span class="currency"><?php echo esc_html( $atts['cur'] ); ?></span>
							<?php endif; ?>
							<?php if ( $atts['price'] ): ?>
                                <span class="price"><?php echo esc_html( $atts['price'] ); ?></span>
							<?php endif; ?>
							<?php if ( $atts['time'] ): ?>
                                <span class="time"><?php echo esc_html( $atts['time'] ); ?></span>
							<?php endif; ?>
                        </div>
                    </div>
					<?php if ( !empty( $list_text ) ): ?>
                        <ul>
							<?php
							foreach ( $list_text as $text ) {
								echo '<li>' . esc_html( $text ) . '</li>';
							}
							?>
                        </ul>
					<?php endif; ?>
					<?php if ( $link_button['url'] != '' ) : ?>
                        <a href="<?php echo esc_url( $link_button['url'] ); ?>"
                           target="<?php echo esc_attr( $link_button['target'] ); ?>"
                           class="button">
							<?php echo esc_html( $link_button['title'] ); ?>
                        </a>
					<?php endif; ?>
                </div>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Pricing_Box', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Pricing_Box();
}