<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Ovic_Pinmapper"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Pinmapper' ) ) {
	class Shortcode_Ovic_Pinmapper extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_pinmapper';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_pinmapper', $atts ) : $atts;
			extract( $atts );
			$html        = '';
			$css_class   = array( 'ovic-pinmap' );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_pinmapper', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* Shortcode html */
			$html .= '<div class="' . esc_attr( implode( ' ', $css_class ) ) . '">';
			if ( $atts['pinmap_style'] ) {
				$html .= ocolus_do_shortcode( 'ovic_pinmap',
					array(
						'id' => $atts['pinmap_style'],
					)
				);
			}
			$html .= '</div>';

			return apply_filters( 'Shortcode_Ovic_Pinmapper', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Pinmapper();
}