<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Person"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Person' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Person extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_person';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_person', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-person', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_person', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			$person_link = vc_build_link( $atts['link'] );
			$link_url    = $person_link['url'] ? $person_link['url'] : '#';
			$link_target = $person_link['target'] ? $person_link['target'] : '_self';
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php $this->get_template( "{$atts['style']}.php",
					array(
						'atts'        => $atts,
						'link_url'    => $link_url,
						'link_target' => $link_target,
					)
				); ?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Person', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Person();
}