<?php
/**
 * Template Person
 *
 * @var $link_url
 * @var $link_target
 * @var $atts
 *
 * @return string
 */
?>
<?php
$second_slide = '';
$main_id      = uniqid( 'person-slide-' );
$thumb_id     = uniqid( 'thumb-slide-' );
$args_slide   = array(
	'infinite'     => true,
	'draggable'    => false,
	'arrows'       => false,
	'slidesMargin' => 0,
	'slidesToShow' => 1,
	'asNavFor'     => "#{$thumb_id}",
);
$args_thumb   = array(
	'slidesToShow'  => 3,
	'infinite'      => true,
	'arrows'        => false,
	'focusOnSelect' => true,
	'centerMode'    => true,
	'centerPadding' => 0,
	'slidesMargin'  => 28,
	'asNavFor'      => "#{$main_id}",
);
$slide_data   = ' data-slick=' . json_encode( $args_slide ) . ' ';
$slide_thumb  = ' data-slick=' . json_encode( $args_thumb ) . ' ';
$persons      = (array)vc_param_group_parse_atts( $atts['persons'] );
?>
<?php if ( !empty( $persons ) ): ?>
    <div id="<?php echo esc_attr( $main_id ); ?>"
         class="owl-slick main-slide" <?php echo esc_attr( $slide_data ); ?>>
		<?php
		foreach ( $persons as $person ) {
			$person_link = vc_build_link( $person['link'] );
			$link_url    = $person_link['url'] ? $person_link['url'] : '#';
			$link_target = $person_link['target'] ? $person_link['target'] : '_self';
			?>
            <div class="person-item">
                <div class="content-person">
					<?php if ( $person['desc'] ) : ?>
                        <p class="desc"><?php echo wp_specialchars_decode( $person['desc'] ); ?></p>
					<?php endif; ?>
					<?php if ( $person['name'] ) : ?>
                        <h3 class="name">
                            <a href="<?php echo esc_url( $link_url ); ?>"
                               target="<?php echo esc_attr( $link_target ); ?>">
								<?php echo esc_html( $person['name'] ); ?>
                            </a>
                        </h3>
					<?php endif; ?>
					<?php if ( $person['positions'] ) : ?>
                        <p class="positions"><?php echo esc_html( $person['positions'] ); ?></p>
					<?php endif; ?>
                </div>
            </div>
			<?php
			/* SECOND THUMB */
			$thumb        = ocolus_resize_image( $person['avatar'], 70, 70, true, true );
			$second_slide .= '';
			$second_slide .= '<div class="person-thumb">';
			$second_slide .= $thumb['img'];
			$second_slide .= '</div>';
		}
		?>
    </div>
    <div id="<?php echo esc_attr( $thumb_id ); ?>"
         class="owl-slick second-slide" <?php echo esc_attr( $slide_thumb ); ?>>
		<?php echo wp_specialchars_decode( $second_slide ); ?>
    </div>
<?php endif;
