<?php
/**
 * Template Person
 *
 * @var $link_url
 * @var $link_target
 * @var $atts
 *
 * @return string
 */
?>
<div class="inner">
	<div class="content-person">
		<?php if ( $atts['avatar'] ) : ?>
			<div class="thumb-avatar">
				<a href="<?php echo esc_url( $link_url ); ?>"
				   target="<?php echo esc_attr( $link_target ); ?>">
					<figure><?php echo wp_get_attachment_image( $atts['avatar'], 'full' ); ?></figure>
				</a>
			</div>
		<?php endif; ?>
		<?php if ( $atts['desc'] ) : ?>
			<p class="desc"><?php echo wp_specialchars_decode( $atts['desc'] ); ?></p>
		<?php endif; ?>
		<div class="person">
			<?php if ( $atts['name'] ) : ?>
				<h3 class="name">
					<a href="<?php echo esc_url( $link_url ); ?>"
					   target="<?php echo esc_attr( $link_target ); ?>">
						<?php echo esc_html( $atts['name'] ); ?>
					</a>
				</h3>
			<?php endif; ?>
			<?php if ( $atts['positions'] ) : ?>
				<p class="positions"><?php echo esc_html( $atts['positions'] ); ?></p>
			<?php endif; ?>
		</div>
	</div>
</div>