<?php
/**
 * Template Person
 *
 * @var $link_url
 * @var $link_target
 * @var $atts
 *
 * @return string
 */
?>
<div class="inner">
	<?php if ( $atts['avatar'] ) : ?>
        <div class="thumb-avatar">
            <a href="<?php echo esc_url( $link_url ); ?>"
               target="<?php echo esc_attr( $link_target ); ?>">
                <figure><?php echo wp_get_attachment_image( $atts['avatar'], 'full' ); ?></figure>
            </a>
        </div>
	<?php endif; ?>
    <div class="content-person">
		<?php if ( $atts['positions'] ) : ?>
            <p class="positions"><?php echo esc_html( $atts['positions'] ); ?></p>
		<?php endif; ?>
		<?php if ( $atts['name'] ) : ?>
            <h3 class="name">
                <a href="<?php echo esc_url( $link_url ); ?>"
                   target="<?php echo esc_attr( $link_target ); ?>">
					<?php echo esc_html( $atts['name'] ); ?>
                </a>
            </h3>
		<?php endif; ?>
        <?php if ( $atts['socials'] ): ?>
            <?php
            $socials = (array)vc_param_group_parse_atts( $atts['socials'] );
            if ( !empty( $socials ) ):
                ?>
                <div class="socials">
                    <?php foreach ( $socials as $social ): ?>
                        <a href="<?php echo esc_url( $social['url'] ) ?>">
                            <span class="<?php echo esc_attr( $social['icon_fontawesome'] ) ?>"></span>
                        </a>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>