<?php
/**
 * Template Person
 *
 * @var $link_url
 * @var $link_target
 * @var $atts
 *
 * @return string
 */
?>
<div class="inner">
	<?php if ( $atts['desc'] ) : ?>
        <p class="desc"><?php echo wp_specialchars_decode( $atts['desc'] ); ?></p>
	<?php endif; ?>
    <?php if ( $atts['name'] ) : ?>
        <h3 class="name">
            <a href="<?php echo esc_url( $link_url ); ?>"
               target="<?php echo esc_attr( $link_target ); ?>">
                <?php echo esc_html( $atts['name'] ); ?>
            </a>
        </h3>
    <?php endif; ?>
	<?php if ( $atts['positions'] ) : ?>
        <p class="positions"><?php echo esc_html( $atts['positions'] ); ?></p>
	<?php endif; ?>
</div>