<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Newsletter"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Newsletter' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Newsletter extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_newsletter';

		public function newsletter_form( $html, $form_id )
		{
			if ( function_exists( 'mc4wp_show_form' ) ) {
				$api_key = mc4wp_get_api_key();
				if ( empty( $api_key ) ) {
					echo sprintf( '<div class="alert alert-warning"><strong>%s</strong> <a href="' . esc_url( 'https://wordpress.org/plugins/mailchimp-for-wp/' ) . '">%s</a></div>',
						esc_html__( 'Warning!', 'ocolus' ),
						esc_html__( 'API key is empty.', 'ocolus' )
					);
				}
				if ( $form_id == 0 ) {
					$form_id = get_option( 'mc4wp_default_form_id' );
					add_filter( 'mc4wp_form_content',
						function ( $content, $form, $element ) use ( $html ) {
							return $html;
						}, 10, 3
					);
					mc4wp_show_form( $form_id );
					remove_all_filters( 'mc4wp_form_content' );
				} else {
					mc4wp_show_form( $form_id );
				}
			} else {
				echo sprintf( '<div class="alert alert-warning"><strong>%s</strong> <a href="' . esc_url( 'https://wordpress.org/plugins/mailchimp-for-wp/' ) . '">%s</a></div>',
					esc_html__( 'Warning!', 'ocolus' ),
					esc_html__( 'Please Active plugin "Mailchimp for WordPress".', 'ocolus' )
				);
			}
		}

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_newsletter', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-newsletter', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_newsletter', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			ob_start();
			$bg_url = '';
			if ( $atts['background'] ) {
				$css_class[] = 'lazy';
				$bg_url      = wp_get_attachment_image_url( $atts['background'], 'full' );
			}
			$form_id = 0;
			if ( !empty( $atts['form_id'] ) ) {
				$form_id = $atts['form_id'];
			}
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>"
                 data-src="<?php echo esc_attr( $bg_url ); ?>">
                <div class="newsletter-wrap">
                    <div class="newsletter-inner">
						<?php if ( $atts['title'] || $atts['desc'] ): ?>
                            <div class="head">
								<?php if ( $atts['title'] ): ?>
                                    <h3 class="title"><?php echo esc_html( $atts['title'] ); ?></h3>
								<?php endif; ?>
								<?php if ( $atts['desc'] ): ?>
                                    <p class="desc"><?php echo wp_specialchars_decode( $atts['desc'] ); ?></p>
								<?php endif; ?>
                            </div>
						<?php endif; ?>
                        <div class="content">
							<?php ob_start(); ?>
                            <label class="text-field field-email">
                                <input class="input-text email-newsletter" type="email" name="EMAIL"
                                       placeholder="<?php echo esc_attr( $atts['placeholder'] ); ?>"
                                       required="required">
                                <span class="input-focus"></span>
                            </label>
                            <button type="submit" class="submit-newsletter"
                                    value="<?php echo esc_attr( $atts['button_text'] ); ?>">
								<?php echo esc_attr( $atts['button_text'] ); ?>
                            </button>
							<?php
							$html = ob_get_clean();
							$this->newsletter_form( $html, $form_id );
							?>
                        </div>
                    </div>
                </div>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Newsletter', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Newsletter();
}