<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Maps"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Maps' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Maps extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $enqueue;
		public $shortcode = 'ovic_maps';

		public function output_html( $atts, $content = null )
		{
			wp_enqueue_script( 'ocolus-maps-api' );
			wp_enqueue_script( $this->enqueue );
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_maps', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-google-maps', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_maps', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			$map_id      = uniqid( 'ovic_gmaps_' );
			ob_start();
			$locations = (array)vc_param_group_parse_atts( $atts['locations'] );
			wp_localize_script( $this->enqueue, "param_{$map_id}",
				array(
					'locations' => $locations,
					'button'    => esc_html__( 'GET DIRECTIONS', 'ocolus' ),
					'zoom'      => $atts['zoom'],
					'maptype'   => $atts['map_type'],
				)
			);
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php if ( $atts['style'] == 'style-01' ): ?>
					<?php if ( !empty( $locations ) ): ?>
                        <section class="map-controls">
                            <div class="search-location">
                                <h2 class="title"><?php echo esc_html__( 'Find store near you', 'ocolus' ); ?></h2>
                                <input id="pac-input-<?php echo esc_attr( $map_id ); ?>" class="search-input"
                                       type="text" onClick="this.setSelectionRange(0, this.value.length)"
                                       placeholder="<?php echo esc_attr_x( 'ENTER CITY/STATE', 'placeholder', 'ocolus' ); ?>">
                                <span class="ti-search" aria-hidden="true"></span>
                            </div>
                            <ul class="locations">
								<?php foreach ( $locations as $key => $location ) :
									$loc_id = "location-{$map_id}-{$key}";
									?>
                                    <li>
                                        <a href="#" id="<?php echo esc_attr( $loc_id ); ?>"
                                           class="location" data-id="<?php echo esc_attr( $key ); ?>">
                                            <p class="title">
												<?php echo esc_html( $location['title'] ); ?>
                                                <span class="fa fa-paper-plane"></span>
                                            </p>
                                            <p class="address">
												<?php echo esc_html( $location['address'] ); ?>
                                            </p>
                                        </a>
                                    </li>
								<?php endforeach; ?>
                            </ul>
                        </section>
					<?php endif; ?>
				<?php endif; ?>
                <section id="<?php echo esc_attr( $map_id ); ?>"
                         class="map-content"
                         style="min-height: <?php echo esc_attr( $atts['map_height'] ); ?>px"></section>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Maps', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Maps();
}