(function ($) {
    'use strict';

    document.addEventListener("DOMContentLoaded", function () {

        $('.ovic-google-maps').each(function () {
            var _this      = $(this),
                _Map       = _this.find('.map-content').attr('id'),
                _Search    = _this.find('.search-input').attr('id'),
                _map_param = window[ 'param_' + _Map ];

            window[ 'markers_' + _Map ] = [];

            var styles = [
                {
                    "featureType": "landscape",
                    "stylers": [
                        {
                            "visibility": "off"
                        }
                    ]
                },
                {
                    "featureType": "poi",
                    "stylers": [
                        {
                            "visibility": "off"
                        }
                    ]
                },
                {
                    "featureType": "road",
                    "elementType": "geometry",
                    "stylers": [
                        {
                            "color": "#ffffff"
                        }
                    ]
                },
                {
                    "featureType": "road",
                    "elementType": "labels",
                    "stylers": [
                        {
                            "visibility": "off"
                        }
                    ]
                },
                {
                    "featureType": "water",
                    "stylers": [
                        {
                            "color": "#dde7e9"
                        }
                    ]
                }
            ];

            var locations  = _map_param.locations,
                map        = new google.maps.Map(document.getElementById(_Map), {
                    zoom: parseInt(_map_param.zoom),
                    disableDefaultUI: true,
                    center: new google.maps.LatLng(
                        locations[ 0 ].longitude,
                        locations[ 0 ].latitude
                    ),
                    mapTypeControlOptions: {
                        mapTypeIds: [ 'Styled' ]
                    },
                    mapTypeId: _map_param.maptype,
                }),
                infowindow = new google.maps.InfoWindow();

            if ( _map_param.maptype === 'Styled' ) {
                var styledMapType = new google.maps.StyledMapType(styles, {name: 'Styled'});
                map.mapTypes.set('Styled', styledMapType);
            }

            function createMarker(marker, html) {

                google.maps.event.addListener(marker, 'click', function () {
                    infowindow.setContent(html);
                    infowindow.open(map, marker);
                    map.setCenter(this.getPosition())
                });

                return marker;
            }

            for ( var i = 0; i < locations.length; i++ ) {
                var geolocation = new google.maps.LatLng(
                    locations[ i ].longitude,
                    locations[ i ].latitude
                );
                var marker      = new google.maps.Marker({
                    position: geolocation,
                    map: map
                });
                /* instal */
                window[ 'markers_' + _Map ][ locations[ i ].title ] =
                    createMarker(marker,
                        "<span class='title-maps'>" + locations[ i ].title + "</span>" +
                        "<span class='address-maps'>" + locations[ i ].address + "</span>" +
                        "<a class='direction-maps' href='" + locations[ i ].url + "' target='_blank'>" + _map_param.button + "</a>"
                    );
                /* Click Change Location */
                if ( document.getElementById('location-' + _Map + '-' + i) !== null ) {
                    document.getElementById('location-' + _Map + '-' + i).onclick = function (e) {
                        var id = this.getAttribute('data-id');
                        google.maps.event.trigger(window[ 'markers_' + _Map ][ locations[ id ].title ], 'click');
                        e.preventDefault();
                    };
                }
            }

            /* Set Default Location */
            google.maps.event.trigger(window[ 'markers_' + _Map ][ locations[ 0 ].title ], "click");

            /* Search Box Locations */
            if ( _Search !== undefined ) {
                var input     = document.getElementById(_Search),
                    searchBox = new google.maps.places.SearchBox(input);

                /* Get Locations */
                searchBox.addListener('places_changed', function () {
                    var places = searchBox.getPlaces();

                    if ( places.length === 0 ) {
                        return;
                    }

                    places.forEach(function (place) {
                        if ( !place.geometry ) {
                            console.log("Returned place contains no geometry");
                            return;
                        }

                        var marker = new google.maps.Marker({
                            position: place.geometry.location,
                            map: map,
                            center: place.geometry.location
                        });

                        if ( place.url === undefined ) {
                            place.url = '#';
                        }

                        infowindow.setContent(
                            "<span class='title-maps'>" + place.name + "</span>" +
                            "<span class='address-maps'>" + place.formatted_address + "</span>" +
                            "<a class='direction-maps' href='" + place.url + "' target='_blank'>" + _map_param.button + "</a>"
                        );
                        infowindow.open(map, marker);

                        map.setCenter(place.geometry.location);
                    });
                });
            }
        });

    });
})(window.jQuery);