<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Iconbox"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Iconbox' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Iconbox extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_iconbox';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_iconbox', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-iconbox' );
			$css_class[] = isset( $atts['style'] ) ? $atts['style'] : '';
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_iconbox', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			$icon_html   = ocolus_get_icon_html( $atts );
			ob_start();
			$link_icon           = vc_build_link( $atts['link'] );
			$link_icon['url']    = ( $link_icon['url'] ) ? $link_icon['url'] : '';
			$link_icon['target'] = ( $link_icon['target'] ) ? $link_icon['target'] : '_self';
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
                <div class="iconbox-inner">
					<?php if ( $icon_html != '' ): ?>
                        <div class="icon">
							<?php if ( $link_icon['url'] != '' ) : ?>
                                <a href="<?php echo esc_url( $link_icon['url'] ); ?>"
                                   target="<?php echo esc_attr( $link_icon['target'] ); ?>">
									<?php echo wp_specialchars_decode( $icon_html ); ?>
                                </a>
							<?php else : ?>
								<?php echo wp_specialchars_decode( $icon_html ); ?>
							<?php endif; ?>
                        </div>
					<?php endif; ?>
                    <div class="content">
						<?php if ( $atts['title'] ): ?>
                            <h4 class="title">
								<?php if ( $link_icon['url'] != '' ) : ?>
                                    <a href="<?php echo esc_url( $link_icon['url'] ); ?>"
                                       target="<?php echo esc_attr( $link_icon['target'] ); ?>">
										<?php echo esc_html( $atts['title'] ); ?>
                                    </a>
								<?php else : ?>
									<?php echo esc_html( $atts['title'] ); ?>
								<?php endif; ?>
                            </h4>
						<?php
						endif;
						if ( $atts['text_content'] ): ?>
                            <p class="text"><?php echo wp_specialchars_decode( $atts['text_content'] ); ?></p>
						<?php endif; ?>
                    </div>
                </div>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Iconbox', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Iconbox();
}