<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Custommenu"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Custommenu' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Custommenu extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_custommenu';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_custommenu', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-custommenu vc_wp_custommenu wpb_content_element', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_custommenu', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			$type        = 'WP_Nav_Menu_Widget';
			$args        = array(
				'before_title' => '<h2 class="widget-title">',
			);
			$instance    = array(
				'title'    => $atts['title'],
				'nav_menu' => $atts['nav_menu'],
			);
			global $wp_widget_factory;
			ob_start();
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php
				if ( is_object( $wp_widget_factory ) && isset( $wp_widget_factory->widgets, $wp_widget_factory->widgets[$type] ) ) {
					the_widget( $type, $instance, $args );
				} else {
					echo esc_html__( 'No content.', 'ocolus' );
				}
				?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Custommenu', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Custommenu();
}