<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Custom_Heading"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Custom_Heading' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Custom_Heading extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_custom_heading';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_custom_heading', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array(
				"ovic-custom-heading",
				$atts['style'],
			);
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_custom_heading', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			if ( $atts['style'] == 'style-26' )
				$css_class[] = $atts['content_size'];
			if ( $atts['style'] == 'style-13' || $atts['style'] == 'style-21' )
				$css_class[] = $atts['text_position'];
            if ( $atts['style'] == 'style-33' ){
                $css_class[] = $atts['text_color'];
                $css_class[] = $atts['text_position_vertical'];
            }
			$class_effect = '';
			if (
				$atts['image_effect'] == 'effect border-scale' ||
				$atts['image_effect'] == 'effect rotate-in rotate-left' ||
				$atts['image_effect'] == 'effect rotate-in rotate-right' ||
				$atts['image_effect'] == 'effect background-zoom'
			) {
				$css_class[] = $atts['image_effect'];
			} else {
				$class_effect = $atts['image_effect'];
			}
			$class_equal = '';
			if ( $atts['style'] == 'style-25' )
				$class_equal = 'equal-elem';
			ob_start();
			$link           = vc_build_link( $atts['button_url'] );
			$link['url']    = $link['url'] != '' ? $link['url'] : '#';
			$link['target'] = $link['target'] != '' ? $link['target'] : '_self';
			$match          = array(
				'style-13',
				'style-14',
				'style-15',
				'style-16',
				'style-18',
				'style-19',
				'style-21',
				'style-25',
				'style-26',
				'style-28',
				'style-29',
				'style-31',
				'style-32',
				'style-33',
			);
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php if ( in_array( $atts['style'], $match ) ) :
					$background = 'backround-color: #eee';
					if ( $atts['background'] )
						$background = 'background-image: url(' . wp_get_attachment_image_url( $atts['background'], 'full' ) . ')';
					?>
                    <div class="inner <?php echo esc_attr( $class_equal ); ?>">
						<?php if ( $atts['background'] && $atts['style'] != 'style-21' && $atts['style'] != 'style-25' ) : ?>
                            <div class="thumb">
                                <figure>
									<?php echo wp_get_attachment_image( $atts['background'], 'full' ); ?>
                                </figure>
                            </div>
						<?php endif; ?>
                        <div class="content">
							<?php if ( $atts['sub_title'] ): ?>
                                <p class="sub-title"><?php echo esc_html( $atts['sub_title'] ); ?></p>
							<?php endif; ?>
							<?php if ( $atts['title'] ): ?>
                                <h3 class="title"><?php echo wp_specialchars_decode( $atts['title'] ); ?></h3>
							<?php endif; ?>
							<?php if ( $atts['desc'] ): ?>
                                <h4 class="desc"><?php echo wp_specialchars_decode( $atts['desc'] ); ?></h4>
							<?php endif; ?>
							<?php if ( $link['title'] ) : ?>
                                <div class="button-wrap">
                                    <a href="<?php echo esc_url( $link['url'] ); ?>"
                                       target="<?php echo esc_attr( $link['target'] ); ?>" class="button">
										<?php echo esc_html( $link['title'] ); ?>
                                    </a>
                                </div>
							<?php endif; ?>
                        </div>
                        <a href="<?php echo esc_url( $link['url'] ); ?>"
                           target="<?php echo esc_attr( $link['target'] ); ?>"
                           class="thumb-link <?php echo esc_attr( $class_effect ); ?>"
							<?php if ( $atts['style'] == 'style-21' || $atts['style'] == 'style-25' ) : ?>
                                style="<?php echo esc_attr( $background ); ?>"
							<?php endif; ?>>
                        </a>
                    </div>
				<?php else : ?>
					<?php if ( $atts['style'] == 'style-24' && $atts['sub_title'] ): ?>
                        <p class="sub-title"><?php echo esc_html( $atts['sub_title'] ); ?></p>
					<?php endif; ?>
					<?php if ( $atts['title'] ): ?>
                        <h3 class="title">
                            <span class="text">
                                <?php echo wp_specialchars_decode( $atts['title'] ); ?>
                            </span>
                        </h3>
					<?php endif; ?>
					<?php if ( $atts['desc'] ): ?>
                        <p class="desc"><?php echo wp_specialchars_decode( $atts['desc'] ); ?></p>
					<?php endif; ?>
					<?php if ( !empty( $atts['countdown'] ) && $atts['enable_countdown'] == true ): ?>
						<?php
						$params = array(
							'hrs_text'  => esc_html__( 'Hrs', 'ocolus' ),
							'mins_text' => esc_html__( 'Mins', 'ocolus' ),
							'secs_text' => esc_html__( 'Secs', 'ocolus' ),
						);
						wp_enqueue_script( 'ocolus-countdown' );
						$atts['countdown'] = apply_filters( 'ovic_change_datetime_countdown', $atts['countdown'], 0 );
						?>
                        <div class="title-countdown-wrapper">
                            <span><?php echo esc_html__( 'End in', 'ocolus' ) ?></span>
                            <div class="ocolus-countdown"
                                 data-datetime="<?php echo esc_attr( $atts['countdown'] ); ?>"
                                 data-params="<?php echo esc_attr( wp_json_encode( $params ) ) ?>">
                            </div>
                        </div>
					<?php endif; ?>
					<?php if ( $atts['button_url'] && $link['title'] ): ?>
                        <a href="<?php echo esc_url( $link['url'] ); ?>" class="button button-heading"
                           target="<?php echo esc_attr( $link['target'] ); ?>">
							<?php echo esc_html( $link['title'] ); ?>
                        </a>
					<?php endif; ?>
				<?php endif; ?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Custom_Heading', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Custom_Heading();
}