<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Coupon"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Coupon' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Coupon extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_coupon';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_coupon', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-coupon', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_coupon', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* START */
			ob_start();
			$css = '';
			if ( $atts['bg'] ) {
				$css = 'background-image: url(' . wp_get_attachment_image_url( $atts['bg'], 'full' ) . ')';
			}
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>" style="<?php echo esc_attr( $css ); ?>">
				<?php if ( $atts['coupons'] ) : ?>
                    <div class="coupon-inner">
						<?php
						$coupons = array_map( 'trim', explode( ',', $atts['coupons'] ) );
						$coupons = get_posts(
							array(
								'orderby'     => 'post__in',
								'order'       => 'asc',
								'post_type'   => 'shop_coupon',
								'post_status' => 'publish',
								'post__in'    => $coupons,
							)
						);
						if ( !empty( $coupons ) )
							foreach ( $coupons as $coupon ) : ?>
                                <div class="coupon-item">
									<?php if ( $coupon->post_excerpt ): ?>
                                        <h3 class="desc">
											<?php echo esc_html( $coupon->post_excerpt ); ?>
                                        </h3>
									<?php endif; ?>
                                    <span class="code">
                                       <?php echo sprintf( '%s: %s', esc_html__( 'CODE', 'ocolus' ), esc_html( $coupon->post_title ) ); ?>
                                   </span>
                                </div>
							<?php endforeach;
						wp_reset_postdata();
						?>
                    </div>
				<?php endif; ?>
            </div>
			<?php
			return apply_filters( 'Shortcode_Ovic_Coupon', ob_get_clean(), $atts, $content );
		}
	}

	new Shortcode_Ovic_Coupon();
}