<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Countdown"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Countdown' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Countdown extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_countdown';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_countdown', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-countdown', 'product-item' );
			$css_class[] = $atts['style'];
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_countdown', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			ob_start();
			$params = array(
				'days_text' => esc_html__( 'Days', 'ocolus' ),
				'hrs_text'  => esc_html__( 'Hrs', 'ocolus' ),
				'mins_text' => esc_html__( 'Mins', 'ocolus' ),
				'secs_text' => esc_html__( 'Secs', 'ocolus' ),
			);
			wp_enqueue_script( 'ocolus-countdown' );
			if ( $atts['format'] && $format = explode( ',', $atts['format'] ) ) {
				$format = (array)$format;
				foreach ( $params as $key => $param ) {
					if ( !in_array( $key, $format ) ) {
						unset( $params[$key] );
					}
				}
			}
			$atts['date'] = apply_filters( 'ovic_change_datetime_countdown', $atts['date'], 0 );
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php if ( $atts['title'] ): ?>
                    <h3 class="title"><?php echo esc_html( $atts['title'] ); ?></h3>
				<?php endif; ?>
                <div class="ocolus-countdown"
                     data-datetime="<?php echo esc_attr( $atts['date'] ); ?>"
                     data-params="<?php echo esc_attr( wp_json_encode( $params ) ) ?>">
                </div>
				<?php if ( $atts['ids'] && class_exists( 'WooCommerce' ) ) {
					if ( get_post_thumbnail_id( $atts['ids'] ) ) {
						echo '<div class="image-product" style="display:none;">' . wp_get_attachment_image( get_post_thumbnail_id( $atts['ids'] ), array( 100, 100 ), false, array( 'class' => 'wp-post-image' ) ) . '</div>';
					}
					echo ocolus_do_shortcode( 'add_to_cart',
						array(
							'id'         => $atts['ids'],
							'show_price' => 'false',
							'style'      => '',
						)
					);
				} ?>
				<?php if ( $atts['button'] ): ?>
					<?php
					$link           = vc_build_link( $atts['button'] );
					$link['url']    = $link['url'] != '' ? $link['url'] : '#';
					$link['target'] = $link['target'] != '' ? $link['target'] : '_self';
					?>
                    <a href="<?php echo esc_url( $link['url'] ) ?>"
                       target="<?php echo esc_attr( $link['target'] ) ?>"
                       class="button">
						<?php echo esc_html( $link['title'] ) ?>
                    </a>
				<?php endif; ?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Countdown', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Countdown();
}