<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_Category"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Category' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Category extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_category';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_category', $atts ) : $atts;
			// Extract shortcode parameters.
			extract( $atts );
			$css_class   = array( 'ovic-category', $atts['style'] );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_category', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* START */
			$slide_data     = Ovic_VC_Params::generate_slide_attr( $atts['carousel'] );
			$cat_item_class = array( 'category-item' );
			$cat_list_class = array( 'category-slide' );
			if ( $atts['style'] == 'style-06' ) {
				$categories = (array)explode( ',', $atts['taxonomy'] );
			} else {
				$categories = (array)vc_param_group_parse_atts( $atts['categories'] );
			}
			if ( $atts['categoriesliststyle'] == 'grid' ) {
				$slide_data       = '';
				$cat_list_class[] = 'row auto-clear';
				$cat_item_class[] = Ovic_VC_Params::generate_grid_attr( $atts['bootstrap'] );
			}
			if ( $atts['categoriesliststyle'] == 'owl' ) {
				$cat_list_class[] = 'owl-slick';
				$cat_item_class[] = $atts['owl_rows_space'];
			}
			ob_start();
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php $this->get_template( "{$atts['style']}.php",
					array(
						'atts'           => $atts,
						'categories'     => $categories,
						'slide_data'     => $slide_data,
						'cat_list_class' => $cat_list_class,
						'cat_item_class' => $cat_item_class,
					)
				); ?>
            </div>
			<?php
			return apply_filters( 'Shortcode_Ovic_Category', ob_get_clean(), $atts, $content );
		}
	}

	new Shortcode_Ovic_Category();
}