<?php
/**
 * Template Category
 *
 * @var $cat_list_class
 * @var $cat_item_class
 * @var $slide_data
 * @var $atts
 *
 * @return string
 */
?>
<?php if ( !empty( $categories ) ) : ?>
    <div class="<?php echo esc_attr( implode( ' ', $cat_list_class ) ); ?>" <?php echo esc_attr( $slide_data ); ?>>
		<?php
		foreach ( $categories as $category ) {
			$term = get_term_by( 'slug', $category['taxonomy'], 'product_cat' );
			if ( $term && !is_wp_error( $term ) ) {
				$url      = get_term_link( $term->term_id, 'product_cat' );
				$image_id = get_term_meta( $term->term_id, 'thumbnail_id', true );
				if ( !empty( $category['image'] ) ) {
					$image_id = $category['image'];
				}
				$image_html = ocolus_resize_image( $image_id, 100, 73, true, true );
				?>
                <div class="<?php echo esc_attr( implode( ' ', $cat_item_class ) ); ?>">
                    <div class="inner">
                        <div class="content">
                            <h3 class="title">
                                <a href="<?php echo esc_url( $url ); ?>">
                                    <?php echo esc_html( $term->name ); ?>
                                </a>
                            </h3>
                            <a href="<?php echo esc_url( $url ); ?>" class="button">
                                <?php echo esc_html__( 'SHOP NOW', 'ocolus' ); ?>
                            </a>
                        </div>
                        <figure class="thumb"><?php echo wp_specialchars_decode( $image_html['img'] ); ?></figure>
                    </div>
                </div>
				<?php
			}
		}
		?>
    </div>
<?php endif; ?>
