<?php
/**
 * Template Category
 *
 * @var $cat_list_class
 * @var $cat_item_class
 * @var $slide_data
 * @var $atts
 *
 * @return string
 */
?>
<div class="category-item">
	<?php if ( $atts['title'] ): ?>
        <h4 class="title"><?php echo esc_html( $atts['title'] ); ?></h4>
	<?php endif; ?>
    <div class="inner-content">
		<?php if ( $atts['image'] ): ?>
            <div class="thumb">
				<?php
				$thumb = ocolus_resize_image( $atts['image'], 170, 190 );
				echo wp_specialchars_decode( $thumb['img'] );
				?>
            </div>
		<?php endif; ?>
		<?php if ( !empty( $categories ) ) : ?>
            <ul class="content-category">
				<?php
				foreach ( $categories as $category ) {
					$term = get_term_by( 'slug', $category, 'product_cat' );
					if ( $term && !is_wp_error( $term ) ) {
						$url = get_term_link( $term->term_id, 'product_cat' );
						?>
                        <li>
                            <a href="<?php echo esc_url( $url ); ?>">
								<?php echo esc_html( $term->name ); ?>
                            </a>
                        </li>
						<?php
					}
				}
				?>
            </ul>
		<?php endif; ?>
    </div>
</div>