<?php
/**
 * Template Category
 *
 * @var $cat_list_class
 * @var $cat_item_class
 * @var $slide_data
 * @var $atts
 *
 * @return string
 */
?>
<?php if ( !empty( $categories ) ) : ?>
	<?php
	$cat_item_class = array( 'category-item' );
	$cat_list_class = array( 'category-slide' );
	?>
    <div class="<?php echo esc_attr( implode( ' ', $cat_list_class ) ); ?>">
		<?php
		foreach ( $categories as $category ) {
			$background = '';
			$class      = array( 'category-content' );
			if ( isset( $category['image'] ) && $category['image'] ) {
				$class[]    = 'lazy';
				$background = " data-src=" . wp_get_attachment_image_url( $category['image'], 'full' ) . " ";
			}
			$term = get_term_by( 'slug', $category['taxonomy'], 'product_cat' );
			if ( $term && !is_wp_error( $term ) ) {
				$url = get_term_link( $term->term_id, 'product_cat' );
				?>
                <div class="<?php echo esc_attr( implode( ' ', $cat_item_class ) ); ?>">
                    <div class="<?php echo esc_attr( implode( ' ', $class ) ); ?>"<?php echo esc_attr( $background ); ?>>
						<?php echo '<h3 class="title"><a href="' . esc_url( $url ) . '">' . esc_html( $term->name ) . '</a></h3>'; ?>
                    </div>
                </div>
				<?php
			}
		}
		?>
    </div>
<?php endif; ?>