<?php
/**
 * Template Category
 *
 * @var $cat_list_class
 * @var $cat_item_class
 * @var $slide_data
 * @var $atts
 *
 * @return string
 */
?>
<?php if ( !empty( $categories ) ) : ?>
    <div class="<?php echo esc_attr( implode( ' ', $cat_list_class ) ); ?>" <?php echo esc_attr( $slide_data ); ?>>
		<?php
		foreach ( $categories as $category ) {
			$term = get_term_by( 'slug', $category['taxonomy'], 'product_cat' );
			if ( $term && !is_wp_error( $term ) ) {
				$url   = get_term_link( $term->term_id, 'product_cat' );
				$image = get_term_meta( $term->term_id, 'thumbnail_id', true );
				if ( isset( $category['image'] ) && $category['image'] ) {
					$image = $category['image'];
				}
				if ( $term->description ) {
					$cat_item_class['desc'] = '';
				} else {
					$cat_item_class['desc'] = 'no-desc';
				}
				$thumb          = ocolus_resize_image( $image, 553, 802, true, true );
				$taxonomy_thumb = '<figure class="category-thumb">' . $thumb['img'] . '</figure>';
				/* HTML */
				?>
                <div class="<?php echo esc_attr( implode( ' ', $cat_item_class ) ); ?>">
					<div class="inner">
                        <?php echo wp_specialchars_decode( $taxonomy_thumb ); ?>
                        <div class="category-content">
                            <?php
                            echo '<h3 class="title"><a href="' . esc_url( $url ) . '">' . esc_html( $term->name ) . '</a></h3>';
                            if ( $term->description ) {
                                echo '<p class="desc">' . wp_trim_words( $term->description, 16, esc_html__( '...', 'ocolus' ) ) . '</p>';
                            }
                            ?>
                            <a href="<?php echo esc_url( $url ); ?>" class="button">
                                <?php
                                if ( $atts['text_button'] == '' ) {
                                    echo esc_html__( 'VIEW COLLECTION', 'ocolus' );
                                } else {
                                    echo esc_html( $atts['text_button'] );
                                }
                                ?>
                            </a>
                        </div>
                    </div>
                </div>
				<?php
			}
		}
		?>
    </div>
<?php endif; ?>