<?php
/**
 * Template Category
 *
 * @var $cat_list_class
 * @var $cat_item_class
 * @var $slide_data
 * @var $atts
 *
 * @return string
 */
?>
<?php if ( !empty( $categories ) ) : ?>
	<?php
	$second_slide   = '';
	$main_id        = uniqid( 'category-slide-' );
	$thumb_id       = uniqid( 'thumb-slide-' );
	$args_slide     = array(
		'infinite'     => false,
		'draggable'    => false,
		'arrows'       => false,
		'fade'         => true,
		'slidesMargin' => 0,
		'slidesToShow' => 1,
		'asNavFor'     => "#{$thumb_id}",
	);
	$args_thumb     = array(
		'slidesToShow'  => 4,
		'infinite'      => false,
		'arrows'        => false,
		'focusOnSelect' => true,
		'slidesMargin'  => 0,
		'asNavFor'      => "#{$main_id}",
		'responsive'    => array(
			array(
				'breakpoint' => 1200,
				'settings'   => array(
					'slidesToShow' => 3,
				),
			),
			array(
				'breakpoint' => 768,
				'settings'   => array(
					'slidesToShow' => 2,
				),
			),
		),
	);
	$slide_data     = ' data-slick=' . json_encode( $args_slide ) . ' ';
	$slide_thumb    = ' data-slick=' . json_encode( $args_thumb ) . ' ';
	$cat_item_class = array( 'category-item' );
	?>
    <div id="<?php echo esc_attr( $main_id ); ?>"
         class="<?php echo esc_attr( implode( ' ', $cat_list_class ) ); ?>" <?php echo esc_attr( $slide_data ); ?>>
		<?php
		foreach ( $categories as $category ) {
			$term = get_term_by( 'slug', $category['taxonomy'], 'product_cat' );
			if ( $term && !is_wp_error( $term ) ) {
				$taxonomy_parent = '';
				if ( $term->parent > 0 ) {
					$term_parent = get_term_by( 'term_id', $term->parent, 'product_cat' );
					if ( $term_parent && !is_wp_error( $term_parent ) ) {
						$taxonomy_parent = '<span class="parent">' . esc_html( $term_parent->name ) . '</span>';
					}
				}
				$url   = get_term_link( $term->term_id, 'product_cat' );
				$image = get_term_meta( $term->term_id, 'thumbnail_id', true );
				if ( isset( $category['image'] ) && $category['image'] ) {
					$image = $category['image'];
				}
				$thumb = ocolus_resize_image( $image, 120, 120, true, true );
				if ( $term->description ) {
					$cat_item_class['desc'] = '';
				} else {
					$cat_item_class['desc'] = 'no-desc';
				}
				$taxonomy_thumb = '<figure class="category-thumb">' . $thumb['img'] . '</figure>';
				$taxonomy_title = '<h3 class="title">' . esc_html( $term->name ) . '</h3>';
				?>
                <div class="<?php echo esc_attr( implode( ' ', $cat_item_class ) ); ?>">
                    <div class="category-content"
                         style="background-image: url(<?php echo wp_get_attachment_image_url( $image, 'full' ); ?>)">
                        <div class="container">
                            <div class="inner">
								<?php
								if ( $atts['title'] ) {
									echo '<p class="sub-title">' . esc_html( $atts['title'] ) . '</p>';
								}
								echo '<h3 class="title"><a href="' . esc_url( $url ) . '">' . esc_html( $term->name ) . '</a></h3>';
								if ( $term->description ) {
									echo '<p class="desc">' . wp_trim_words( $term->description, 16, esc_html__( '...', 'ocolus' ) ) . '</p>';
								}
								?>
                                <a href="<?php echo esc_url( $url ); ?>" class="button">
									<?php
									if ( $atts['text_button'] == '' ) {
										echo esc_html__( 'VIEW COLLECTION', 'ocolus' );
									} else {
										echo esc_html( $atts['text_button'] );
									}
									?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
				<?php
				/* SECOND THUMB */
				$second_slide .= '';
				$second_slide .= '<div class="category-item">';
				$second_slide .= $taxonomy_thumb;
				$second_slide .= '<div class="category-content">';
				$second_slide .= $taxonomy_parent;
				$second_slide .= $taxonomy_title;
				$second_slide .= '</div>';
				$second_slide .= '</div>';
			}
		}
		?>
    </div>
    <div id="<?php echo esc_attr( $thumb_id ); ?>"
         class="owl-slick second-slide" <?php echo esc_attr( $slide_thumb ); ?>>
		<?php echo wp_specialchars_decode( $second_slide ); ?>
    </div>
<?php endif; ?>