<?php
/**
 * Template Category
 *
 * @var $cat_list_class
 * @var $cat_item_class
 * @var $slide_data
 * @var $atts
 *
 * @return string
 */
?>
<?php if ( !empty( $categories ) ) : ?>
    <div class="<?php echo esc_attr( implode( ' ', $cat_list_class ) ); ?>" <?php echo esc_attr( $slide_data ); ?>>
		<?php
		foreach ( $categories as $category ) {
			$taxonomy = '';
			if ( isset( $category['taxonomy'] ) ) {
				$taxonomy = $category['taxonomy'];
			}
			$term = get_term_by( 'slug', $taxonomy, 'product_cat' );
			if ( $term && !is_wp_error( $term ) ) {
				$url   = get_term_link( $term->term_id, 'product_cat' );
				$image = get_term_meta( $term->term_id, 'thumbnail_id', true );
				if ( isset( $category['image'] ) && $category['image'] ) {
					$image = $category['image'];
				}
				if ( $term->description ) {
					$cat_item_class['desc'] = '';
				} else {
					$cat_item_class['desc'] = 'no-desc';
				}
				/* HTML */
				?>
                <div class="<?php echo esc_attr( implode( ' ', $cat_item_class ) ); ?>">
                    <div class="category-inner">
						<?php echo '<figure class="category-thumb">' . wp_get_attachment_image( $image, 'full' ) . '</figure>'; ?>
                        <div class="category-content">
							<?php
							if ( $term->parent > 0 ) {
								$term_parent = get_term_by( 'term_id', $term->parent, 'product_cat' );
								if ( $term_parent && !is_wp_error( $term_parent ) ) {
									$parent_url = get_term_link( $term->term_id, 'product_cat' );
									echo '<a href="' . esc_url( $parent_url ) . '" class="parent">' . esc_html( $term_parent->name ) . '</a>';
								}
							}
							echo '<h3 class="title"><a href="' . esc_url( $url ) . '">' . esc_html( $term->name ) . '</a></h3>';
							if ( $term->description ) {
								echo '<p class="desc">' . wp_trim_words( $term->description, 18, esc_html__( '...', 'ocolus' ) ) . '</p>';
							}
							?>
                            <a href="<?php echo esc_url( $url ); ?>" class="button">
								<?php
								if ( $atts['text_button'] == '' ) {
									echo esc_html__( 'VIEW COLLECTION', 'ocolus' );
								} else {
									echo esc_html( $atts['text_button'] );
								}
								?>
                            </a>
                        </div>
                    </div>
                </div>
				<?php
			}
		}
		?>
    </div>
<?php endif; ?>