<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Ovic_Blog"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_Blog' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Blog extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_blog';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_blog', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-blog' );
			$css_class[] = $atts['style'];
			$css_class[] = $atts['owl_dot_style'];
			$css_class[] = $atts['owl_navigation_style'];
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_blog', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* START */
			$i               = 0;
			$post_slide_data = '';
			$post_item_class = array( 'blog-item', $atts['style'] );
			$post_list_class = array( 'content-post equal-container better-height' );
			if ( $atts['postliststyle'] == 'grid' ) {
				$post_list_class[] = 'row auto-clear';
				$post_item_class[] = Ovic_VC_Params::generate_grid_attr( $atts['bootstrap'] );
			} elseif ( $atts['postliststyle'] == 'owl' ) {
				$post_list_class[] = 'owl-slick';
				$post_item_class[] = $atts['owl_rows_space'];
				$post_slide_data   = Ovic_VC_Params::generate_slide_attr( $atts['carousel'] );
			} elseif ( $atts['postliststyle'] == 'isotope' ) {
				wp_enqueue_script( 'ocolus-grid-isotope' );
				$post_list_class[] = $atts['isotope_rows_space'];
				$post_list_class[] = 'ocolus-isotope';
				$post_item_class[] = 'isotope-item';
			}
			$query = new WP_Query( ocolus_shortcode_posts_query( $atts ) );
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php if ( $query->have_posts() ) : ?>
					<?php
					$functions    = array();
					$func_isotope = array();
					if ( $atts['full_size'] == 'enable' ) {
						$functions = array(
							array( 'add_filter', 'ocolus_post_thumbnail_width', function () { return false; } ),
							array( 'add_filter', 'ocolus_post_thumbnail_height', function () { return false; } ),
						);
					}
					ocolus_add_action( $functions );
					?>
                    <div class="<?php echo esc_attr( implode( ' ', $post_list_class ) ); ?>"
						<?php echo esc_attr( $post_slide_data ); ?>
						<?php
						if ( $atts['postliststyle'] == 'isotope' ) {
							echo " data-layout={$atts['layout_mode']}";
						}
						if ( $atts['col'] != '0' ) {
							echo " data-cols={$atts['col']}";
						} ?>>
						<?php while ( $query->have_posts() ) : $query->the_post();
							if ( $i % 2 == 0 ) {
								$post_item_class['position'] = 'left';
							} else {
								$post_item_class['position'] = 'right';
							}
							$i++;
							if ( $atts['postliststyle'] == 'isotope' ) {
								$meta_post = get_post_meta( get_the_ID(), '_custom_post_side_options', true );
								if ( $atts['current_size'] != 'enable' ) {
									$width  = 470;
									$height = 300;
									if ( isset( $meta_post['post_size_masonry'] ) ) {
										if ( $meta_post['post_size_masonry'] == 'medium' ) {
											$height = 550;
										}
									}
									$func_isotope = array(
										array( 'add_filter', 'ocolus_post_thumbnail_width', function () use ( $width ) { return $width; } ),
										array( 'add_filter', 'ocolus_post_thumbnail_height', function () use ( $height ) { return $height; } ),
									);
								}
								ocolus_add_action( $func_isotope );
							}
							?>
                            <article <?php post_class( $post_item_class ); ?>>
								<?php
								ocolus_get_template(
									"templates/blog/blog-shortcode/content-blog-{$atts['style']}.php",
									array(
										'atts'     => $atts,
										'position' => $post_item_class['position'],
									)
								);
								?>
                            </article>
							<?php ocolus_add_action( $func_isotope ); ?>
						<?php endwhile; ?>
                    </div>
					<?php ocolus_add_action( $functions, true ); ?>
				<?php else :
					get_template_part( 'content', 'none' );
				endif; ?>
            </div>
			<?php
			wp_reset_postdata();
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Blog', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Blog();
}