<?php

if ( !class_exists( 'Shortcode_Ovic_Accordions' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_Accordions extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $shortcode = 'ovic_accordion';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_accordion', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-accordion' );
			$css_class[] = isset( $atts['style'] ) ? $atts['style'] : '';
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_accordion', $atts );
			$sections    = $this->get_all_attributes( 'vc_tta_section', $content );
			$rand        = uniqid();
			ob_start();
			?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>" role="tablist"
                 aria-multiselectable="true">
				<?php if ( $sections && is_array( $sections ) && count( $sections ) > 0 ): ?>
					<?php foreach ( $sections as $key => $section ) : ?>
						<?php
						$class_tab         = array( 'panel-collapse collapse' );
						$class_items       = array( 'panel panel-default' );
						$class_link        = array( 'tab-link' );
						$section_id        = $section['tab_id'] . '-' . $rand;
						$section['i_type'] = isset( $section['i_type'] ) ? $section['i_type'] : 'fontawesome';
						$add_icon          = isset( $section['add_icon'] ) ? $section['add_icon'] : '';
						$position_icon     = isset( $section['i_position'] ) ? $section['i_position'] : '';
						if ( $section['i_type'] == 'image' && !empty( $section['image_icon'] ) ) {
							$icon_html = wp_get_attachment_image( $section['image_icon'], 'full' );
						} else {
							$icon_html = $this->constructIcon( $section );
						}
						if ( $key == $atts['active_section'] ) {
							$class_items[] = 'active';
							$class_link[]  = 'loaded';
							$class_tab[]   = 'in';
						}
						?>
                        <div class="<?php echo esc_attr( implode( ' ', $class_items ) ); ?>">
                            <div class="panel-heading" role="tab"
                                 id="accordion-<?php echo esc_attr( $section_id ); ?>">
                                <h4 class="panel-title">
                                    <a class="<?php echo esc_attr( implode( ' ', $class_link ) ); ?>"
                                       data-ajax="<?php echo esc_attr( $atts['ajax_check'] ) ?>"
                                       data-animate="<?php echo esc_attr( $atts['css_animation'] ); ?>"
                                       data-section="<?php echo esc_attr( md5( $section['tab_id'] ) ); ?>"
                                       data-parent=".<?php echo esc_attr( $atts['ovic_vc_custom_id'] ); ?>"
                                       aria-controls="<?php echo esc_attr( $section_id ); ?>"
                                       href="#<?php echo esc_attr( $section_id ); ?>">
										<?php echo ( 'true' === $add_icon && 'right' !== $position_icon ) ? $icon_html : ''; ?>
                                        <span><?php echo esc_html( $section['title'] ); ?></span>
										<?php echo ( 'true' === $add_icon && 'right' === $position_icon ) ? $icon_html : ''; ?>
                                    </a>
                                </h4>
                            </div>
                            <div id="<?php echo esc_attr( $section_id ); ?>"
                                 role="tabpanel"
                                 class="<?php echo esc_attr( implode( ' ', $class_tab ) ); ?>"
                                 aria-labelledby="accordion-<?php echo esc_attr( $section_id ); ?>">
								<?php if ( $atts['ajax_check'] == '1' ) :
									wp_localize_script( "ocolus-main", "ovic_vc_tta_section_" . md5( $section['tab_id'] ), array( 'content' => urlencode( $section['content'] ) ) );
									if ( $key == $atts['active_section'] ) :
										echo wpb_js_remove_wpautop( $section['content'] );
									endif;
								else :
									echo wpb_js_remove_wpautop( $section['content'] );
								endif; ?>
                            </div>
                        </div>
					<?php endforeach; ?>
				<?php endif; ?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_Accordions', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_Accordions();
}