<?php
if ( !defined( 'ABSPATH' ) ) {
	die( '-1' );
}
/**
 * Shortcode attributes
 * @var $atts
 * Shortcode class
 * @var $this "Shortcode_Ovic_360degree"
 * @version 1.0.0
 */
if ( !class_exists( 'Shortcode_Ovic_360degree' ) && class_exists( 'Ovic_VC_Shortcode' ) ) {
	class Shortcode_Ovic_360degree extends Ovic_VC_Shortcode
	{
		/**
		 * Shortcode name.
		 *
		 * @var  string
		 */
		public $enqueue;
		public $shortcode = 'ovic_360degree';

		public function output_html( $atts, $content = null )
		{
			$atts = function_exists( 'vc_map_get_attributes' ) ? vc_map_get_attributes( 'ovic_360degree', $atts ) : $atts;
			extract( $atts );
			$css_class   = array( 'ovic-360degree' );
			$css_class[] = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, '', 'ovic_360degree', $atts );
			$css_class[] = $this->getCSSAnimation( $atts['css_animation'] );
			/* START */
			wp_enqueue_style( $this->enqueue );
			wp_enqueue_script( $this->enqueue );
			ob_start(); ?>
            <div class="<?php echo esc_attr( implode( ' ', $css_class ) ); ?>">
				<?php
				$images_string = array();
				$images        = explode( ',', $atts['gallery_degree'] );
				if ( !empty( $images ) && count( $images ) > 0 ): ?>
					<?php
					$width  = 300;
					$height = 300;
					foreach ( $images as $img_id ) {
						list( $img, $width, $height ) = wp_get_attachment_image_src( $img_id, 'full' );
						$images_string[] = $img;
					}
					?>
                    <div class="ovic-threed-view"
                         data-images="<?php echo esc_attr( json_encode( $images_string ) ); ?>"
                         data-width="<?php echo esc_attr( $width ); ?>"
                         data-height="<?php echo esc_attr( $height ); ?>">
                        <ol class="threed-view-images"></ol>
                        <div class="spinner">
                            <span>0%</span>
                        </div>
                    </div>
				<?php endif; ?>
            </div>
			<?php
			$html = ob_get_clean();

			return apply_filters( 'Shortcode_Ovic_360degree', $html, $atts, $content );
		}
	}

	new Shortcode_Ovic_360degree();
}