<?php
if ( have_posts() ):
	while ( have_posts() ): the_post(); ?>
        <article <?php post_class( 'post-item' ); ?>>
            <div class="post-head">
				<?php
				ocolus_post_taxonomy( null, 'portfolio-category' );
                echo '<h2 class="post-title"><span>' . get_the_title() . '</span></h2>';
				ocolus_post_excerpt( null );
				ocolus_portfolio_meta_single();
				?>
                <div class="share-content">
                    <span class="title"><?php echo esc_html__( 'SHARE', 'ocolus' ); ?></span>
					<?php ocolus_share_social(); ?>
                </div>
            </div>
			<?php if ( has_post_thumbnail() ): ?>
				<?php
				$slick     = array();
				$post_id   = get_the_ID();
				$class     = 'gallery-content';
				$html      = '';
				$post_meta = get_post_meta( $post_id, '_custom_portfolio_side_options', true );
				if ( !empty( $post_meta['gallery'] ) ) {
					$galleries = explode( ',', $post_meta['gallery'] );
					$class     .= ' owl-slick';
					$slick     = array(
						'infinite'      => true,
						'variableWidth' => true,
						'centerMode'    => true,
						'centerPadding' => 0,
						'slidesMargin'  => 20,
						'slidesToShow'  => 2,
						'arrows'        => false,
						'dots'          => true,
						'responsive'    => array(
                            array(
                                'breakpoint' => 768,
                                'settings'   => array(
                                    'variableWidth' => false,
                                    'centerMode'    => false,
                                    'slidesToShow'  => 1,
                                ),
                            ),
                        ),
					);
					if ( !empty( $galleries ) )
						foreach ( $galleries as $image_id ) {
							$html .= '<figure>' . wp_get_attachment_image( $image_id, 'full' ) . '</figure>';
						}
				}
				?>
                <div class="post-gallery">
                    <div class="<?php echo esc_attr( $class ); ?>"
                         data-slick="<?php echo esc_attr( json_encode( $slick ) ); ?>">
						<?php echo wp_specialchars_decode( $html ); ?>
                    </div>
                </div>
			<?php endif; ?>
			<?php
			ocolus_post_content();
			/*If comments are open or we have at least one comment, load up the comment template.*/
			if ( comments_open() || get_comments_number() ) :
				comments_template();
			endif;
			ocolus_pagination_portfolio();
			?>
        </article>
	<?php
	endwhile;
	wp_reset_postdata();
else :
	get_template_part( 'content', 'none' );
endif;