<?php
/**
 * Name:  Portfolio Carousel
 **/
?>
<?php
$fullwidth = ocolus_get_option( 'portfolio_full_width' );
$gutter    = ocolus_get_option( 'portfolio_gutter' );
$slick     = array(
	'infinite'     => false,
	'slidesToShow' => 3,
	'slidesMargin' => 0,
);
if ( $gutter == 1 ) {
    $slick['slidesMargin'] = 20;
}
if ( $fullwidth == 1 ) {
	$slick['infinite']      = true;
	$slick['centerMode']    = true;
	$slick['centerPadding'] = 0;
	$slick['slidesToShow']  = 2;
}
$slick['responsive'] = array(
    array(
        'breakpoint' => 992,
        'settings'   => array(
            'slidesToShow' => 2,
        ),
    ),
    array(
        'breakpoint' => 768,
        'settings'   => array(
            'slidesToShow' => 1,
        ),
    ),
);
ocolus_portfolio_block_filter();
?>
<?php if ( have_posts() ): ?>
    <div class="portfolio-content response-content owl-slick"
         data-slick="<?php echo esc_attr( json_encode( $slick ) ); ?>">
		<?php
		while ( have_posts() ): the_post(); ?>
            <article <?php post_class( 'portfolio-item isotope-item style-01' ); ?>>
				<?php get_template_part( 'templates/portfolio/portfolio-style/content', 'style-01' ); ?>
            </article>
		<?php
		endwhile;
		wp_reset_postdata();
		remove_all_filters( 'ocolus_post_thumbnail_width' );
		remove_all_filters( 'ocolus_post_thumbnail_height' );
		?>
    </div>
	<?php ocolus_post_pagination(); ?>
<?php else :
	get_template_part( 'content', 'none' );
endif;
