<?php
/**
 * Name:  Header style 21
 **/
?>
<?php
$socials        = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_social',
	'metabox_header_social'
);
$text           = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_text',
	'metabox_header_text',
	''
);
$header_sidebar = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_sidebar'
);
?>
<header id="header" class="header style-21 ocolus-dropdown overlay">
	<?php if ( $text != '' ) : ?>
        <div class="header-top">
            <div class="container">
				<?php echo wp_specialchars_decode( $text ); ?>
            </div>
        </div>
	<?php endif; ?>
    <div class="header-mid">
        <div class="container">
            <div class="header-inner">
                <div class="header-left">
					<?php
					if ( !empty( $socials ) ) {
						echo ocolus_do_shortcode( 'ovic_socials',
							array(
								'socials' => $socials,
							)
						);
					}
					?>
                </div>
                <div class="header-center">
                    <div class="logo"><?php ocolus_get_logo(); ?></div>
                </div>
                <div class="header-right">
					<?php
					ocolus_header_search( 'style-02' );
					if ( function_exists( 'ocolus_header_mini_cart' ) ) ocolus_header_mini_cart();
					?>
					<?php if ( $header_sidebar ): ?>
                        <div class="block-canvas-bar">
                            <a href="javascript:void(0)" class="canvas-open" data-ocolus="ocolus-dropdown">
                                <span class="icon"><span></span><span></span><span></span></span>
                            </a>
                        </div>
					<?php endif; ?>
                    <div class="mobile-block block-menu-bar">
                        <a href="javascript:void(0)" class="menu-bar menu-toggle">
                            <span class="icon"><span></span><span></span><span></span></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header-bot">
        <div class="container">
            <div class="box-header-nav megamenu-wrap">
				<?php
				if ( has_nav_menu( 'primary' ) )
					wp_nav_menu( array(
							'menu'            => 'primary',
							'theme_location'  => 'primary',
							'depth'           => 3,
							'container'       => '',
							'container_class' => '',
							'container_id'    => '',
							'menu_class'      => 'main-menu',
						)
					);
				?>
            </div>
        </div>
    </div>
	<?php
	if ( $header_sidebar )
		ocolus_header_canvas( $header_sidebar, false );
	?>
</header>