<?php
/**
 * Name:  Header style 19
 **/
?>
<?php
$text           = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_text',
	'metabox_header_text',
	''
);
$banner_menu    = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_banner'
);
$banner_url     = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_banner_url'
);
?>
<header id="header" class="header style-19 megamenu-wrap ocolus-dropdown overlay">
	<?php if ( $banner_menu ): ?>
        <div class="header-banner">
            <a href="<?php echo esc_url( $banner_url ); ?>">
                <?php echo wp_get_attachment_image( $banner_menu, 'full' ) ?>
            </a>
        </div>
	<?php endif; ?>
    <div class="header-top">
        <div class="container">
            <div class="header-inner">
				<?php if ( $text != '' ) : ?>
                    <div class="header-left">
						<?php echo wp_specialchars_decode( $text ); ?>
                    </div>
				<?php endif; ?>
                <div class="header-right">
					<?php ocolus_get_header_menu( 'header_top_menu' ); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="header-mid">
        <div class="container">
            <div class="header-inner megamenu-wrap">
                <div class="header-left">
                    <div class="logo"><?php ocolus_get_logo(); ?></div>
                    <?php ocolus_header_vertical( 'vertical' ); ?>
                </div>
                <div class="header-center">
					<?php ocolus_header_search( 'style-03' ); ?>
                </div>
                <div class="header-right">
					<?php
					ocolus_user_link( esc_html__( 'My Account', 'ocolus' ) );
					if ( function_exists( 'ocolus_header_mini_cart' ) )
						ocolus_header_mini_cart();
					?>
                    <div class="mobile-block block-menu-bar">
                        <a href="javascript:void(0)" class="menu-bar menu-toggle">
                            <span class="icon"><span></span><span></span><span></span></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header-bot">
        <div class="container">
            <div class="box-header-nav megamenu-wrap">
				<?php
				if ( has_nav_menu( 'primary' ) )
					wp_nav_menu( array(
							'menu'            => 'primary',
							'theme_location'  => 'primary',
							'depth'           => 3,
							'container'       => '',
							'container_class' => '',
							'container_id'    => '',
							'menu_class'      => 'main-menu',
						)
					);
				?>
            </div>
        </div>
    </div>
</header>