<?php
/**
 * Name:  Header style 18
 **/
?>
<?php
$banner_menu     = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_banner'
);
$banner_url      = ocolus_theme_option_meta(
	'_custom_metabox_theme_options',
	'header_banner_url'
);
$enable_vertical = ocolus_get_option( 'enable_vertical_menu' );
?>
<header id="header" class="header style-18 <?php if ( $enable_vertical == 1 ) echo esc_attr( 'has-vertical-menu' ); ?>">
	<?php if ( $banner_menu ): ?>
        <div class="header-banner">
            <a href="<?php echo esc_url( $banner_url ); ?>">
                <figure><?php echo wp_get_attachment_image( $banner_menu, 'full' ) ?></figure>
            </a>
        </div>
	<?php endif; ?>
    <div class="header-top">
        <div class="container">
            <div class="header-inner">
                <div class="header-left">
                    <?php ocolus_get_header_menu( 'header_top_menu' ); ?>
                </div>
                <div class="header-right">
                    <?php ocolus_get_header_menu( 'header_second_menu' ); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="header-mid">
        <div class="container">
            <div class="header-inner">
                <div class="header-left">
                    <div class="logo"><?php ocolus_get_logo(); ?></div>
                </div>
                <div class="header-center">
                    <?php ocolus_header_search(
                        'style-03',
                        '',
                        esc_html__( 'Search', 'ocolus' )
                    );
                    ?>
                </div>
                <div class="header-right">
                    <?php
                    ocolus_user_link();
                    if ( function_exists( 'ocolus_header_mini_cart' ) )
                        ocolus_header_mini_cart();
                    ?>
                    <div class="mobile-block block-menu-bar">
                        <a href="javascript:void(0)" class="menu-bar menu-toggle">
                            <span class="icon"><span></span><span></span><span></span></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="header-bot">
        <div class="container">
			<div class="header-inner megamenu-wrap">
                <?php ocolus_header_vertical( 'vertical' ); ?>
                <div class="box-header-nav megamenu-wrap">
                    <?php
                    if ( has_nav_menu( 'primary' ) )
                        wp_nav_menu( array(
                                'menu'            => 'primary',
                                'theme_location'  => 'primary',
                                'depth'           => 3,
                                'container'       => '',
                                'container_class' => '',
                                'container_id'    => '',
                                'menu_class'      => 'main-menu',
                            )
                        );
                    ?>
                </div>
            </div>
        </div>
    </div>
</header>