<?php if ( have_posts() ):
	while ( have_posts() ): the_post(); ?>
        <article <?php post_class( 'post-item' ); ?>>
            <div class="meta-data">
				<?php ocolus_post_category(); ?>
                <h4 class="post-title"><span><?php the_title(); ?></span></h4>
            </div>
			<?php if ( has_post_thumbnail() ): ?>
                <div class="post-thumb">
					<?php the_post_thumbnail( 'full' ); ?>
                </div>
			<?php endif; ?>
            <div class="post-info wrapper-main-content" style="position: relative;">
                <?php
                $enable         = ocolus_get_option( 'enable_share' );
                if ( $enable == 1 ) :
                    ?>
                    <div class="single-post-social sticky-content">
                        <div>
                            <h4 class="title"><?php echo esc_html__( 'SHARE', 'ocolus' ); ?></h4>
                            <?php ocolus_share_button(); ?>
                        </div>
                        <div>
                            <h4 class="title"><?php echo esc_html__( 'WRITTEN BY', 'ocolus' ); ?></h4>
                            <?php ocolus_post_author(); ?>
                        </div>
                        <div>
                            <h4 class="title"><?php echo esc_html__( 'DATE', 'ocolus' ); ?></h4>
                            <?php the_date(); ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="post-single-content">
					<?php ocolus_post_content(); ?>
                    <div class="social-author">
						<?php if ( get_the_author_meta( 'facebook' ) ) : ?>
                            <a target="_blank" class="facebook"
                               href="<?php echo get_the_author_meta( 'facebook' ); ?>">
                                <i class="fa fa-facebook"></i>
                            </a>
						<?php endif; ?>
						<?php if ( get_the_author_meta( 'twitter' ) ) : ?>
                            <a target="_blank" class="twitter"
                               href="<?php echo get_the_author_meta( 'twitter' ); ?>">
                                <i class="fa fa-twitter"></i>
                            </a>
						<?php endif; ?>
						<?php if ( get_the_author_meta( 'google' ) ) : ?>
                            <a target="_blank" class="google-plus"
                               href="<?php echo get_the_author_meta( 'google' ); ?>">
                                <i class="fa fa-google"></i>
                            </a>
						<?php endif; ?>
						<?php if ( get_the_author_meta( 'instagram' ) ) : ?>
                            <a target="_blank" class="instagram"
                               href="<?php echo get_the_author_meta( 'instagram' ); ?>">
                                <i class="fa fa-instagram"></i>
                            </a>
						<?php endif; ?>
						<?php if ( get_the_author_meta( 'youtube' ) ) : ?>
                            <a target="_blank" class="youtube"
                               href="<?php echo get_the_author_meta( 'youtube' ); ?>">
                                <i class="fa fa-youtube-play"></i>
                            </a>
						<?php endif; ?>
                    </div>
					<?php
					/*If comments are open or we have at least one comment, load up the comment template.*/
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
					?>
                </div>
            </div>
        </article>
	<?php
	endwhile;
	wp_reset_postdata();
else :
	get_template_part( 'content', 'none' );
endif;