<?php
global $post;
$enable_related = ocolus_get_option( 'enable_related_post' );
$categories     = get_the_category( $post->ID );
if ( $categories && $enable_related == 1 ) : ?>
	<?php
	$margin         = 30;
	$style_related  = 'style-18';
	$number_related = ocolus_get_option( 'related_post_per_page', 6 );
	$related_layout = ocolus_get_option( 'related_post_layout', 'normal' );
	$title_related  = ocolus_get_option( 'related_post_title', 'Related Posts' );
	if ( $related_layout != 'normal' ) {
		$style_related = 'style-15';
		$margin        = 0;
	}
	$data         = array(
		'infinite'     => false,
		'slidesToShow' => 3,
		'slidesMargin' => $margin,
		'responsive'   => array(
			array(
				'breakpoint' => 1500,
				'settings'   => array(
					'slidesToShow' => 3,
				),
			),
			array(
				'breakpoint' => 1200,
				'settings'   => array(
					'slidesToShow' => 3,
				),
			),
			array(
				'breakpoint' => 992,
				'settings'   => array(
					'slidesToShow' => 2,
				),
			),
			array(
				'breakpoint' => 768,
				'settings'   => array(
					'slidesToShow' => 2,
				),
			),
			array(
				'breakpoint' => 576,
				'settings'   => array(
					'slidesToShow' => 1,
				),
			),
		),
	);
	$generate     = ' data-slick=' . json_encode( $data ) . ' ';
	$category_ids = array();
	foreach ( $categories as $value ) {
		$category_ids[] = $value->term_id;
	}
	$args      = array(
		'category__in'        => $category_ids,
		'post__not_in'        => array( $post->ID ),
		'posts_per_page'      => $number_related,
		'ignore_sticky_posts' => 1,
		'orderby'             => 'rand',
	);
	$new_query = new wp_query( $args );
	if ( $new_query->have_posts() ) : ?>
        <div class="related-post <?php echo esc_attr( $related_layout ); ?>">
            <h3 class="title"><?php echo esc_html( $title_related ); ?></h3>
            <div class="owl-slick" <?php echo esc_attr( $generate ); ?>>
				<?php while ( $new_query->have_posts() ): $new_query->the_post(); ?>
                    <article <?php post_class( array( 'post-item', $style_related ) ); ?>>
						<?php get_template_part( 'templates/blog/blog-style/content-blog', $style_related ); ?>
                    </article>
				<?php endwhile; ?>
            </div>
        </div>
	<?php endif;
	wp_reset_postdata();
endif;