<?php
/**
 * Name:  Blog Split
 **/
?>
<?php
$sticky   = get_option( 'sticky_posts' );
$data     = array(
	'infinite'      => true,
    'autoplay'      => true,
	'autoplaySpeed' => 3000,
	'speed'         => 3000,
	'slidesToShow'  => 1,
	'slidesMargin'  => 16,
	'dots'          => true,
	'arrows'        => false,
);
$generate = ' data-slick=' . json_encode( $data ) . ' ';
?>
<?php if ( have_posts() ): ?>
    <div class="wrapper-main-content" style="position: relative;">
		<?php if ( !empty( $sticky ) ): ?>
			<?php
			$args  = array(
				'post_type'   => 'post',
				'post_status' => 'publish',
				'post__in'    => $sticky,
			);
			$query = new wp_query( $args );
			if ( $query->have_posts() ): ?>
                <div class="head-post-sticky sticky-content">
                    <div class="owl-slick" <?php echo esc_attr( $generate ); ?>>
                        <?php while ( $query->have_posts() ): $query->the_post(); ?>
                            <article <?php post_class( 'post-item style-19' ); ?>>
                                <?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-19' ); ?>
                            </article>
                        <?php endwhile;
                        wp_reset_postdata(); ?>
                    </div>
                </div>
			<?php endif;
		endif; ?>
        <div class="inner-main-content">
            <div class="blog-content ocolus-isotope response-content sticky-content-static" data-layout="packery">
                <?php while ( have_posts() ): the_post(); ?>
                    <?php
                    $meta_post = get_post_meta( get_the_ID(), '_custom_post_side_options', true );
                    $class     = 'small';
                    $width     = 456;
                    $height    = 406;
                    if ( isset( $meta_post['post_size_split'] ) ) {
                        if ( $meta_post['post_size_split'] == 'medium_h' ) {
                            $width = 828;
                        } elseif ( $meta_post['post_size_split'] == 'medium_v' ) {
                            $height = 928;
                        } elseif ( $meta_post['post_size_split'] == 'large' ) {
                            $width  = 928;
                            $height = 828;
                        }
                        $class = $meta_post['post_size_split'];
                    }
                    add_filter( 'ocolus_post_thumbnail_width', function () use ( $width ) {
                        return $width;
                    }
                    );
                    add_filter( 'ocolus_post_thumbnail_height', function () use ( $height ) {
                        return $height;
                    }
                    );
                    ?>
                    <article <?php post_class( 'post-item isotope-item style-14 ' . $class ); ?>>
                        <?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-14' ); ?>
                    </article>
                    <?php
                    remove_all_filters( 'ocolus_post_thumbnail_width' );
                    remove_all_filters( 'ocolus_post_thumbnail_height' );
                endwhile;
                wp_reset_postdata(); ?>
            </div>
            <?php ocolus_post_pagination(); ?>
        </div>
    </div>
<?php else :
	get_template_part( 'content', 'none' );
endif;