<?php
/**
 * Name:  Blog Metro
 **/
?>
<?php if ( have_posts() ): ?>
    <div class="blog-content ocolus-isotope response-content" data-layout="packery">
		<?php while ( have_posts() ): the_post(); ?>
			<?php
			$meta_post = get_post_meta( get_the_ID(), '_custom_post_side_options', true );
			$class     = 'small';
			$width     = 480;
			$height    = 480;
			if ( isset( $meta_post['post_size'] ) ) {
				if ( $meta_post['post_size'] == 'medium_h' ) {
					$width = 960;
				} elseif ( $meta_post['post_size'] == 'medium_v' ) {
					$height = 960;
				} elseif ( $meta_post['post_size'] == 'large' ) {
					$width  = 960;
					$height = 960;
				}
				$class = $meta_post['post_size'];
			}
			add_filter( 'ocolus_post_thumbnail_width', function () use ( $width ) {
				return $width;
			});
			add_filter( 'ocolus_post_thumbnail_height', function () use ( $height ) {
				return $height;
			});
			?>
            <article <?php post_class( 'post-item isotope-item style-13 ' . $class ); ?>>
				<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-13' ); ?>
            </article>
			<?php
			remove_all_filters( 'ocolus_post_thumbnail_width' );
			remove_all_filters( 'ocolus_post_thumbnail_height' );
		endwhile;
		wp_reset_postdata(); ?>
    </div>
	<?php ocolus_post_pagination(); ?>
<?php else :
	get_template_part( 'content', 'none' );
endif;
