<?php
/**
 * Name:  Blog Masonry
 **/
?>
<?php if ( have_posts() ): ?>
	<?php $column = ocolus_get_option( 'blog_column', '4' ); ?>
    <div class="blog-content ocolus-isotope response-content" data-cols="<?php echo esc_attr( $column ); ?>" data-layout="packery">
		<?php while ( have_posts() ): the_post(); ?>
			<?php
			$meta_post = get_post_meta( get_the_ID(), '_custom_post_side_options', true );
			$class     = 'small';
			$width     = 435;
			$height    = 435;
			if ( isset( $meta_post['post_size_masonry'] ) ) {
				if ( $meta_post['post_size_masonry'] == 'medium' ) {
					$height = 600;
				}
				$class = $meta_post['post_size_masonry'];
			}
			add_filter( 'ocolus_post_thumbnail_width', function () use ( $width ) {
				return $width;
			});
			add_filter( 'ocolus_post_thumbnail_height', function () use ( $height ) {
				return $height;
			});
			?>
            <article <?php post_class( 'post-item isotope-item style-16 ' . $class ); ?>>
				<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-16' ); ?>
            </article>
			<?php
			remove_all_filters( 'ocolus_post_thumbnail_width' );
			remove_all_filters( 'ocolus_post_thumbnail_height' );
		endwhile;
		wp_reset_postdata(); ?>
    </div>
	<?php ocolus_post_pagination(); ?>
<?php else :
	get_template_part( 'content', 'none' );
endif;
