<?php
/**
 * Name:  Blog List v2
 **/
?>
<?php
$sticky   = get_option( 'sticky_posts' );
$data     = array(
	'infinite'      => true,
	'slidesToShow'  => 1,
	'slidesMargin'  => 30,
	'autoplay'      => true,
	'autoplaySpeed' => 3000,
	'speed'         => 3000,
	'arrows'        => false,
);
$generate = ' data-slick=' . json_encode( $data ) . ' ';
if ( !empty( $sticky ) ): ?>
	<?php
	$args  = array(
		'post_type'           => 'post',
		'post_status'         => 'publish',
		'ignore_sticky_posts' => 1,
		'post__in'            => $sticky,
	);
	$query = new wp_query( $args );
	if ( $query->have_posts() ): ?>
        <div class="head-post-sticky owl-slick" <?php echo esc_attr( $generate ); ?>>
			<?php while ( $query->have_posts() ): $query->the_post(); ?>
                <article <?php post_class( 'post-item style-08' ); ?>>
					<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-08' ); ?>
                </article>
			<?php endwhile;
			wp_reset_postdata(); ?>
        </div>
	<?php endif;
endif; ?>
<?php if ( have_posts() ): ?>
    <div class="blog-content response-content">
		<?php while ( have_posts() ): the_post(); ?>
            <article <?php post_class( 'post-item style-09' ); ?>>
				<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-09' ); ?>
            </article>
		<?php endwhile;
		wp_reset_postdata(); ?>
    </div>
	<?php ocolus_post_pagination(); ?>
<?php else :
	get_template_part( 'content', 'none' );
endif;
