<?php
/**
 * Name:  Blog Grid Full Width
 **/
?>
<?php
$sticky   = get_option( 'sticky_posts' );
$data     = array(
	'infinite'      => true,
	'centerMode'    => true,
	'variableWidth' => true,
	'slidesToShow'  => 3,
	'initialSlide'  => 1,
	'slidesMargin'  => 10,
	'autoplay'      => true,
	'autoplaySpeed' => 3000,
	'speed'         => 3000,
);
$generate = ' data-slick=' . json_encode( $data ) . ' ';
if ( !empty( $sticky ) ): ?>
	<?php
	$args  = array(
		'post_type'   => 'post',
		'post_status' => 'publish',
		'post__in'    => $sticky,
	);
	$query = new wp_query( $args );
	if ( $query->have_posts() ): ?>
        <div class="head-post-sticky owl-slick" <?php echo esc_attr( $generate ); ?>>
			<?php while ( $query->have_posts() ): $query->the_post(); ?>
                <article <?php post_class( 'post-item style-04' ); ?>>
					<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-04' ); ?>
                </article>
			<?php endwhile;
			wp_reset_postdata(); ?>
        </div>
	<?php endif;
endif; ?>
<?php if ( have_posts() ): ?>
	<?php $column = ocolus_get_option( 'blog_column', '4' ); ?>
    <div class="blog-content ocolus-isotope response-content equal-container better-height"
         data-cols="<?php echo esc_attr( $column ); ?>" data-layout="fitRows" data-full="1">
		<?php while ( have_posts() ): the_post(); ?>
            <article <?php post_class( 'post-item isotope-item style-17' ); ?>>
				<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-17' ); ?>
            </article>
		<?php endwhile;
		wp_reset_postdata(); ?>
    </div>
	<?php ocolus_post_pagination(); ?>
<?php else :
	get_template_part( 'content', 'none' );
endif;
