<?php
/**
 * Name:  Blog Full Screen
 **/
?>
<?php
$sticky   = get_option( 'sticky_posts' );
$data     = array(
	'infinite'      => true,
	'slidesToShow'  => 1,
	'slidesMargin'  => 16,
	'autoplay'      => true,
	'autoplaySpeed' => 3000,
	'speed'         => 5000,
);
$generate = ' data-slick=' . json_encode( $data ) . ' ';
if ( !empty( $sticky ) ): ?>
	<?php
	$args  = array(
		'post_type'   => 'post',
		'post_status' => 'publish',
		'post__in'    => $sticky,
	);
	$query = new wp_query( $args );
	if ( $query->have_posts() ):
		add_filter( 'ocolus_post_thumbnail_width', function () { return 1920; } );
		add_filter( 'ocolus_post_thumbnail_height', function () { return 750; } );
		?>
        <div class="head-post-sticky owl-slick" <?php echo esc_attr( $generate ); ?>>
			<?php while ( $query->have_posts() ): $query->the_post(); ?>
                <article <?php post_class( 'post-item style-03' ); ?>>
					<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-03' ); ?>
                </article>
			<?php endwhile;
			wp_reset_postdata(); ?>
        </div>
		<?php
		remove_all_filters( 'ocolus_post_thumbnail_width' );
		remove_all_filters( 'ocolus_post_thumbnail_height' );
	endif;
endif; ?>
<?php if ( have_posts() ): ?>
    <div class="blog-content response-content">
		<?php while ( have_posts() ): the_post(); ?>
            <article <?php post_class( 'post-item style-03' ); ?>>
				<?php get_template_part( 'templates/blog/blog-style/content-blog', 'style-03' ); ?>
            </article>
		<?php endwhile;
		wp_reset_postdata(); ?>
    </div>
	<?php ocolus_post_pagination(); ?>
<?php else :
	get_template_part( 'content', 'none' );
endif;
